/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.AbstractBoxRenderer;
import io.intino.konos.builder.codegeneration.BoxConfigurationRenderer;
import io.intino.konos.builder.codegeneration.BoxRenderer;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.UIAccessorCreator;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterRenderer;
import io.intino.konos.builder.codegeneration.datahub.feeder.FeederRenderer;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubRenderer;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterRenderer;
import io.intino.konos.builder.codegeneration.datahub.process.ProcessRenderer;
import io.intino.konos.builder.codegeneration.exception.ExceptionRenderer;
import io.intino.konos.builder.codegeneration.main.MainRenderer;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.services.jms.JMSRequestRenderer;
import io.intino.konos.builder.codegeneration.services.jms.JMSServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXOperationsServiceRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTResourceRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceRenderer;
import io.intino.konos.builder.codegeneration.services.slack.SlackRenderer;
import io.intino.konos.builder.codegeneration.services.ui.UIServiceRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogsRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplaysRenderer;
import io.intino.konos.builder.codegeneration.services.ui.resource.ResourceRenderer;
import io.intino.konos.builder.codegeneration.task.SchedulerRenderer;
import io.intino.konos.builder.codegeneration.task.TaskRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.plugin.codeinsight.linemarkers.InterfaceToJavaImplementation;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FullRenderer {
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    private final KonosGraph graph;
    private final File gen;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final String parent;
    private final boolean hasModel;
    private final Map<String, String> classes;
    private File res;

    public FullRenderer(@Nullable Module module, KonosGraph graph, File src, File gen, File res, String packageName) {
        this.project = module == null ? null : module.getProject();
        this.module = module;
        this.graph = graph;
        this.gen = gen;
        this.src = src;
        this.res = res;
        this.packageName = packageName;
        this.parent = this.parent();
        this.hasModel = this.hasModel();
        this.boxName = StringHelper.snakeCaseToCamelCase((String)this.boxName());
        this.classes = new HashMap<String, String>();
    }

    public void execute() {
        cottons.utils.Files.removeDir((File)this.gen);
        this.schemas();
        this.exceptions();
        this.rest();
        this.tasks();
        this.jmx();
        this.jms();
        this.bus();
        this.slack();
        this.ui();
        this.box();
        this.main();
        InterfaceToJavaImplementation.nodeMap.clear();
        InterfaceToJavaImplementation.nodeMap.putAll(this.classes);
    }

    private void schemas() {
        new SchemaRenderer(this.graph, this.gen, this.packageName, this.classes).execute();
    }

    private void exceptions() {
        new ExceptionRenderer(this.graph, this.gen, this.packageName).execute();
    }

    private void rest() {
        new RESTResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new RESTServiceRenderer(this.graph, this.gen, this.res, this.packageName, this.boxName, this.module, this.classes).execute();
    }

    private void jmx() {
        new JMXOperationsServiceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new JMXServerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void jms() {
        new JMSRequestRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new JMSServiceRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void tasks() {
        new TaskRenderer(this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new SchedulerRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
    }

    private void bus() {
        if (this.graph.dataHub() == null) {
            return;
        }
        new ProcessRenderer(this.graph, this.src, this.packageName, this.boxName, this.classes).execute();
        new MessageHubRenderer(this.graph, this.gen, this.src, this.packageName, this.boxName, this.classes).execute();
        new MounterRenderer(this.graph, this.gen, this.src, this.packageName, this.boxName, this.classes).execute();
        new AdapterRenderer(this.graph, this.src, this.packageName, this.boxName, this.classes).execute();
        new FeederRenderer(this.graph, this.gen, this.src, this.packageName, this.boxName, this.classes).execute();
    }

    private void slack() {
        new SlackRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
    }

    private void ui() {
        new DisplayRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.parent, this.boxName, this.classes).execute();
        new DisplaysRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new DialogsRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new DialogRenderer(this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new ResourceRenderer(this.project, this.graph, this.src, this.gen, this.packageName, this.boxName, this.classes).execute();
        new UIServiceRenderer(this.graph, this.gen, this.packageName, this.boxName).execute();
        new UIAccessorCreator(this.module, this.graph, this.parent).execute();
    }

    private void box() {
        new AbstractBoxRenderer(this.graph, this.gen, this.packageName, this.module, this.parent, this.hasModel).execute();
        new BoxRenderer(this.graph, this.src, this.packageName, this.module, this.hasModel).execute();
        new BoxConfigurationRenderer(this.gen, this.packageName, this.module, this.parent, this.hasModel).execute();
    }

    private String boxName() {
        return this.module != null ? TaraUtil.configurationOf((Module)this.module).artifactId() : Configuration.Level.Solution.name();
    }

    private String parent() {
        try {
            if (this.module == null) {
                return null;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module.getProject());
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            List languages = configuration.languages();
            if (languages.isEmpty() || ((Configuration.LanguageLibrary)languages.get(0)).generationPackage() == null) {
                return null;
            }
            String workingPackage = ((Configuration.LanguageLibrary)languages.get(0)).generationPackage().replace(".graph", "");
            PsiClass aClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> facade.findClass(workingPackage + ".box." + Formatters.firstUpperCase(((Configuration.LanguageLibrary)languages.get(0)).name()) + "Box", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)));
            if (aClass != null) {
                return workingPackage.toLowerCase() + ".box." + Formatters.firstUpperCase(((Configuration.LanguageLibrary)languages.get(0)).name());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    private boolean hasModel() {
        return this.module != null && TaraUtil.configurationOf((Module)this.module) != null && this.hasModel(TaraUtil.configurationOf((Module)this.module));
    }

    private boolean hasModel(Configuration configuration) {
        return !configuration.languages().isEmpty();
    }

    private void main() {
        new MainRenderer(this.src, this.hasModel, this.packageName, this.module).execute();
        File file = new File(this.res, "log4j.properties");
        if (!file.exists()) {
            try {
                Files.write(file.toPath(), this.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/log4j_model.properties"));
    }
}

