/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;

public class BoxConfigurationRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private String parent;
    private boolean isTara;

    public BoxConfigurationRenderer(File gen, String packageName, Module module, String parent, boolean isTara) {
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.isTara = isTara;
    }

    public void execute() {
        FrameBuilder builder = new FrameBuilder(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(builder);
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().render((Object)builder.toFrame()));
    }

    private String fillFrame(FrameBuilder builder) {
        String boxName = this.name();
        builder.add("name", (Object)boxName).add("package", (Object)this.packageName);
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            builder.add("parent", (Object)this.parent);
        }
        if (this.isTara) {
            builder.add("tara", (Object)"");
        }
        return boxName;
    }

    private String name() {
        return this.module != null ? this.configuration.artifactId() : Configuration.Level.Solution.name();
    }

    private Template template() {
        return Formatters.customize(new BoxConfigurationTemplate());
    }
}

