/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ParameterPublisher;
import io.intino.konos.builder.codegeneration.datahub.feeder.FeederRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Broker;
import io.intino.konos.model.graph.DataHub;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.mirrored.MirroredDataHub;
import io.intino.konos.model.graph.realtime.RealtimeMounter;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.standalone.StandAloneDataHub;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractBoxRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final KonosGraph graph;
    private final Configuration configuration;
    private final String parent;
    private final boolean hasModel;
    private final Set<String> customParameters;

    AbstractBoxRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean hasModel) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.hasModel = hasModel;
        this.customParameters = new HashSet<String>();
    }

    public void execute() {
        FrameBuilder root = new FrameBuilder(new String[]{"box"});
        String boxName = this.name();
        root.add("name", (Object)boxName).add("package", (Object)this.packageName);
        if (this.hasModel) {
            root.add("tara", (Object)boxName);
        }
        this.parent(root);
        this.services(root, boxName);
        this.tasks(root, boxName);
        this.dataHub(root, boxName);
        this.graph.datamartList().forEach(d -> this.datamart(root, (Datamart)((Object)d)));
        Commons.writeFrame(this.gen, "AbstractBox", this.template().render((Object)root.toFrame()));
        this.notifyNewParameters();
    }

    private void datamart(FrameBuilder root, Datamart datamart) {
        root.add("datamart", (Object)new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("value", (Object)datamart.path()));
    }

    private void notifyNewParameters() {
        new ParameterPublisher((LegioConfiguration)this.configuration).publish(this.customParameters);
    }

    private void tasks(FrameBuilder builder, String boxName) {
        if (!this.graph.taskList().isEmpty()) {
            builder.add("task", (Object)new FrameBuilder(new String[]{"task"}).add("configuration", (Object)boxName).toFrame());
        }
    }

    private void dataHub(FrameBuilder builder, String boxName) {
        Frame[] mounterFrames;
        DataHub dataHub = this.graph.dataHub();
        if (dataHub == null) {
            return;
        }
        FrameBuilder dataHubFrame = new FrameBuilder(new String[]{"datahub", this.type(dataHub)}).add("workspace", (Object)this.parameter(dataHub.workingDirectory(), new String[0]));
        if (!dataHub.tankList().isEmpty()) {
            FrameBuilder tanks = new FrameBuilder(new String[]{"tanks"});
            for (DataHub.Split split : dataHub.splitList()) {
                tanks.add("split", (Object)this.frameOf(split));
            }
            for (DataHub.Tank tank : dataHub.tankList()) {
                tanks.add("tank", (Object)this.frameOf(tank));
            }
            dataHubFrame.add("tanks", (Object)tanks.toFrame());
        }
        if (dataHub.isStandAlone()) {
            StandAloneDataHub service = dataHub.asStandAlone();
            if (service.broker() != null) {
                this.addBroker(dataHubFrame, service.broker());
            }
            FrameBuilder frame = new FrameBuilder(new String[]{"standalone"}).add("path", (Object)this.parameter(service.datalakePath(), new String[0])).add("scale", (Object)service.scale());
            if (service.seal() != null) {
                frame.add("sealing", (Object)service.seal().when());
            }
            dataHubFrame.add("datasource", (Object)frame);
        } else if (dataHub.isMirrored()) {
            this.mirroredDataSource(dataHub, dataHubFrame);
        } else if (dataHub.isRemote()) {
            this.remoteDataSource(dataHub, dataHubFrame);
        } else if (dataHub.isLocal()) {
            dataHubFrame.add("datasource", (Object)new FrameBuilder(new String[]{"local"}).add("path", (Object)this.parameter(dataHub.asLocal().datalakePath(), new String[0])));
        }
        Frame[] feederFrames = (Frame[])this.graph.dataHub().feederList().stream().filter(f -> !f.sensorList().isEmpty()).map(this::frameOf).toArray(Frame[]::new);
        if (feederFrames.length != 0) {
            dataHubFrame.add("feeder", (Object)feederFrames);
        }
        if ((mounterFrames = (Frame[])this.graph.dataHub().mounterList().stream().filter(Mounter::isRealtime).map(m -> this.frameOf((Mounter)((Object)m), boxName)).toArray(Frame[]::new)).length != 0) {
            dataHubFrame.add("mounter", (Object)mounterFrames);
        }
        builder.add("dataHub", (Object)dataHubFrame.toFrame());
    }

    private Frame frameOf(Mounter m, String boxName) {
        RealtimeMounter mounter = m.asRealtime();
        FrameBuilder[] subscriptions = (FrameBuilder[])mounter.selectList().stream().map(s -> s.tank().fullName()).map(t -> new FrameBuilder(new String[]{"subscription"}).add("tankName", t).add("box", (Object)boxName).add("package", (Object)this.packageName).add("name", (Object)mounter.name$()).add("subscriberId", (Object)mounter.subscriberId())).toArray(FrameBuilder[]::new);
        FrameBuilder mounterFrame = new FrameBuilder(new String[]{"mounter", "realtime"});
        return mounterFrame.add("name", (Object)mounter.name$()).add("subscription", (Object)subscriptions).toFrame();
    }

    private void remoteDataSource(DataHub dataHub, FrameBuilder dataHubFrame) {
        FrameBuilder remote = new FrameBuilder(new String[]{"remote"});
        if (dataHub.asRemote().messageHub() != null) {
            remote.add("messageHub", (Object)this.messageHubFrame(dataHub.asRemote().messageHub()));
        }
        dataHubFrame.add("datasource", (Object)remote);
    }

    private void mirroredDataSource(DataHub dataHub, FrameBuilder dataHubFrame) {
        MirroredDataHub mirrored = dataHub.asMirrored();
        if (mirrored.broker() != null) {
            this.addBroker(dataHubFrame, mirrored.broker());
        }
        FrameBuilder mirror = new FrameBuilder(new String[]{"mirror"}).add("originUrl", (Object)this.parameter(mirrored.originSshUrl(), new String[0])).add("originPath", (Object)this.parameter(mirrored.originDatalakePath(), new String[0])).add("startingTimetag", (Object)mirrored.startingTimetag()).add("user", (Object)this.parameter(mirrored.user(), new String[0])).add("password", (Object)(mirrored.password() == null ? "" : this.parameter(mirrored.password(), new String[0]))).add("destinationPath", (Object)this.parameter(mirrored.destinationPath(), new String[0]));
        if (mirrored.messageHub() != null) {
            mirror.add("messageHub", (Object)this.messageHubFrame(dataHub.asMirrored().messageHub()));
        }
        dataHubFrame.add("datasource", (Object)mirror);
    }

    private Frame frameOf(DataHub.Split split) {
        return new FrameBuilder(new String[]{"split"}).add("name", (Object)split.name$()).add("value", (Object)split.splits().toArray(new String[0])).toFrame();
    }

    private Frame frameOf(DataHub.Tank tank) {
        String[] objects = (String[])tank.core$().conceptList().stream().map(s -> s.id().split("#")[0]).toArray(String[]::new);
        FrameBuilder builder = new FrameBuilder(objects).add("tank").add("name", (Object)tank.fullName()).add("type", (Object)objects[0]);
        if (tank.isSet() && tank.asSet().split() != null) {
            builder.add("splitName", (Object)tank.asSet().split().name$());
        }
        return builder.toFrame();
    }

    @NotNull
    private FrameBuilder messageHubFrame(MessageHub hub) {
        FrameBuilder frame = new FrameBuilder(new String[]{"messageHub"});
        if (hub.isJmsHub()) {
            frame.add("jms").add("parameter", (Object)this.parameter(hub.busUrl(), new String[0])).add("parameter", (Object)this.parameter(hub.user(), new String[0])).add("parameter", (Object)this.parameter(hub.password(), new String[0])).add("parameter", (Object)this.parameter(hub.clientId(), new String[0]));
        }
        FrameBuilder frameBuilder = frame.add("package", (Object)this.packageName);
        if (frameBuilder == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private void addBroker(FrameBuilder dataHubFrame, Broker broker) {
        FrameBuilder brokerFrame = new FrameBuilder().add("port", (Object)this.parameter(broker.port() + "", "int")).add("mqtt_port", (Object)this.parameter(broker.mqtt_port() + "", "int")).add("connectorId", (Object)this.parameter(broker.connectorId(), new String[0]));
        broker.pipeList().forEach(pipe -> brokerFrame.add("pipe", (Object)new FrameBuilder().add("origin", (Object)pipe.origin()).add("destination", (Object)pipe.destination())));
        broker.userList().forEach(user -> brokerFrame.add("user", (Object)new FrameBuilder().add("name", (Object)this.parameter(user.name(), new String[0])).add("password", (Object)this.parameter(user.password(), new String[0]))));
        dataHubFrame.add("broker", (Object)brokerFrame);
    }

    private String type(DataHub dataHub) {
        return ((String[])dataHub.core$().conceptList().stream().map(s -> s.id().split("#")[0]).toArray(String[]::new))[0];
    }

    @NotNull
    private FrameBuilder parameter(String parameter, String ... types) {
        FrameBuilder frameBuilder = new FrameBuilder(types).add("parameter").add(this.isCustom(parameter) ? "custom" : "standard").add("value", (Object)parameter);
        if (frameBuilder == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(1);
        }
        return frameBuilder;
    }

    private Frame frameOf(Feeder feeder) {
        return new FrameBuilder(new String[]{"feeder"}).add("package", (Object)this.packageName).add("name", (Object)FeederRenderer.name(feeder)).add("box", (Object)this.name()).toFrame();
    }

    private void services(FrameBuilder builder, String name) {
        if (!this.graph.jMSServiceList().isEmpty()) {
            builder.add("jms", (Object)"");
        }
        this.rest(builder, name);
        this.jms(builder, name);
        this.jmx(builder, name);
        this.slackServices(builder, name);
        if (!this.graph.rESTServiceList().isEmpty() || !this.graph.uIServiceList().isEmpty()) {
            builder.add("spark", (Object)"stop");
        }
        this.ui(builder, name);
    }

    private void rest(FrameBuilder frame, String name) {
        for (RESTService service : this.graph.rESTServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "rest"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private void jms(FrameBuilder frame, String name) {
        for (JMSService service : this.graph.jMSServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jms"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.user(), new String[0]).toFrame()).add("parameter", (Object)this.parameter(service.password(), new String[0]).toFrame()).add("parameter", (Object)this.parameter(service.url(), new String[0]).toFrame()).toFrame());
        }
    }

    private void jmx(FrameBuilder frame, String name) {
        for (JMXService service : this.graph.jMXServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jmx"}).add("name", (Object)service.name$()).add("configuration", (Object)name).toFrame());
        }
    }

    private void slackServices(FrameBuilder frame, String name) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "slack"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service)).toFrame());
        }
    }

    private void ui(FrameBuilder builder, String name) {
        if (!this.graph.uIServiceList().isEmpty()) {
            FrameBuilder uiFrame = new FrameBuilder();
            if (this.parent != null) {
                uiFrame.add("parent", (Object)this.parent);
            }
            builder.add("hasUi", (Object)uiFrame);
            builder.add("uiAuthentication", (Object)uiFrame);
            builder.add("uiEdition", (Object)uiFrame);
            builder.add("service", this.graph.uIServiceList().stream().map(s -> this.ui((UIService)((Object)s), name)).toArray(Frame[]::new));
        }
    }

    private Frame ui(UIService service, String name) {
        FrameBuilder builder = new FrameBuilder(new String[]{"service", "ui"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0]).toFrame());
        if (service.authentication() != null) {
            builder.add("authentication", (Object)this.parameter(service.authentication().by(), new String[0]).toFrame());
        }
        if (service.edition() != null) {
            builder.add("edition", (Object)new FrameBuilder(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).add("value", (Object)service.edition().by()).toFrame());
        }
        service.useList().forEach(use -> builder.add("use", (Object)(use.className() + "Service")));
        return builder.toFrame();
    }

    @NotNull
    private Frame parameter(SlackBotService service) {
        Frame frame = new FrameBuilder(new String[]{this.isCustom(service.token()) ? "custom" : "standard"}).add("value", (Object)service.token()).toFrame();
        if (frame == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(2);
        }
        return frame;
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.customParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(FrameBuilder builder) {
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            builder.add("parent", (Object)this.parent).add("hasParent", (Object)"");
        } else {
            builder.add("hasntParent", (Object)"");
        }
    }

    private String name() {
        return this.module != null ? this.configuration.artifactId() : Configuration.Level.Solution.name();
    }

    private Template template() {
        return Formatters.customize(new AbstractBoxTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/intino/konos/builder/codegeneration/AbstractBoxRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "messageHubFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parameter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

