/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayTemplate;
import io.intino.konos.model.graph.Display;
import java.io.File;
import java.util.Objects;

public class DisplayUpdater {
    private final PsiElementFactory factory;
    private final PsiFile file;
    private Project project;
    private Display display;
    private String packageName;
    private Application application = ApplicationManager.getApplication();

    DisplayUpdater(Project project, Display display, File file, String packageName) {
        this.project = project;
        this.factory = JavaPsiFacade.getElementFactory((Project)project);
        this.display = display;
        this.packageName = packageName;
        this.file = (PsiFile)this.application.runReadAction(() -> PsiManager.getInstance((Project)project).findFile(Objects.requireNonNull(VfsUtil.findFileByIoFile((File)file, (boolean)true))));
    }

    public void update() {
        PsiClass psiClass = (PsiClass)this.application.runReadAction(() -> {
            if (!(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
                return null;
            }
            return ((PsiJavaFile)this.file).getClasses()[0];
        });
        if (!this.application.isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        for (Display.Request request : this.display.requestList()) {
            if (this.methodOf(request, psiClass) != null) continue;
            this.addMethod(psiClass, request);
        }
    }

    private void addMethod(PsiClass psiClass, Display.Request request) {
        String methodText = Formatters.customize(new DisplayTemplate()).render((Object)DisplayRenderer.frameOf(request, this.packageName));
        psiClass.addAfter((PsiElement)this.factory.createMethodFromText(methodText, (PsiElement)psiClass), (PsiElement)psiClass.getMethods()[psiClass.getMethods().length - 1]);
    }

    private PsiMethod methodOf(Display.Request request, PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getName().equals(this.nameOf(request))) continue;
            return psiMethod;
        }
        return null;
    }

    private String nameOf(Display.Request request) {
        return Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)request.name$()).toString());
    }
}

