/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.dialog;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;

public class DialogsRenderer
extends UIRenderer {
    private final File gen;
    private final List<Dialog> dialogs;

    public DialogsRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        super(boxName, packageName);
        this.gen = gen;
        this.dialogs = graph.dialogList();
    }

    public void execute() {
        if (this.dialogs.isEmpty()) {
            return;
        }
        FrameBuilder frame = this.frameBuilder();
        for (Dialog dialog : this.dialogs) {
            frame.add("dialog", (Object)this.dialogFrame(dialog));
        }
        this.write(frame);
    }

    private Frame dialogFrame(Dialog dialog) {
        return new FrameBuilder(new String[]{"dialog"}).add("name", (Object)dialog.name$()).add("type", (Object)((Object)((Object)dialog)).getClass().getSimpleName()).toFrame();
    }

    private void write(FrameBuilder builder) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)"Dialogs");
        Commons.writeFrame(new File(this.gen, "dialogs"), newDisplay, this.template().render((Object)builder.toFrame()));
    }

    private Template template() {
        return Formatters.customize(new DialogsTemplate());
    }

    @Override
    protected FrameBuilder frameBuilder() {
        return super.frameBuilder().add("dialogs");
    }
}

