/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.UIServiceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Set;

public class UIServiceRenderer
extends UIRenderer {
    private final File gen;
    private final List<UIService> uiServiceList;

    public UIServiceRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        super(boxName, packageName);
        this.gen = gen;
        this.uiServiceList = graph.uIServiceList();
    }

    public void execute() {
        this.uiServiceList.forEach(this::processUIService);
    }

    private void processUIService(UIService service) {
        List<Dialog> dialogs = KonosGraph.dialogsOf(service);
        List<Display> displays = KonosGraph.displaysOf(service);
        FrameBuilder builder = this.frameBuilder().add("ui").add("name", (Object)service.name$()).add("resource", (Object)this.resourcesFrame(service.resourceList()));
        if (service.userHome() != null) {
            builder.add("userHome", (Object)service.userHome().name$());
        }
        if (!dialogs.isEmpty()) {
            builder.add("dialog", (Object)this.dialogsFrame(dialogs)).add("dialogsImport", (Object)this.packageName);
        }
        if (!displays.isEmpty()) {
            builder.add("display", (Object)this.displaysFrame(displays)).add("displaysImport", (Object)this.packageName);
        }
        if (service.authentication() != null) {
            builder.add("auth", (Object)service.authentication().by());
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)(service.name$() + "Service")), this.template().render((Object)builder.toFrame()));
    }

    private Frame[] resourcesFrame(List<AbstractUIService.Resource> resourceList) {
        return (Frame[])resourceList.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] displaysFrame(List<Display> displays) {
        return (Frame[])displays.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] dialogsFrame(List<Dialog> dialogs) {
        return (Frame[])dialogs.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(AbstractUIService.Resource resource) {
        UIService service = (UIService)resource.core$().ownerAs(UIService.class);
        String path = resource.path();
        Set<String> custom = Commons.extractParameters(path);
        FrameBuilder builder = new FrameBuilder(new String[]{"resource", "abstractResource"}).add("name", (Object)resource.name$());
        FrameBuilder pathFrameBuilder = new FrameBuilder(new String[]{"path"}).add("value", (Object)path).add("name", (Object)resource.name$());
        if (resource.isEditorPage()) {
            pathFrameBuilder.add("editor");
        }
        if (service.userHome() != null) {
            pathFrameBuilder.add("userHome", (Object)service.userHome().name$());
        }
        if (!custom.isEmpty()) {
            pathFrameBuilder.add("custom", (Object)custom.toArray(new String[0]));
        }
        builder.add("path", (Object)pathFrameBuilder.toFrame());
        return builder.toFrame();
    }

    private Frame frameOf(Display display) {
        FrameBuilder builder = this.newDisplayFrame(display, new FrameBuilder(new String[]{"display"}));
        if (display.isAccessible()) {
            builder.add("accessible").add("display", (Object)this.newDisplayFrame(display, new FrameBuilder(new String[]{"display", "proxy"})).toFrame());
        }
        return builder.toFrame();
    }

    private FrameBuilder newDisplayFrame(Display display, FrameBuilder builder) {
        builder.add("name", (Object)display.name$()).add("package", (Object)this.packageName);
        if (display.requestList().stream().anyMatch(r -> r.responseType().equals((Object)Display.Request.ResponseType.Asset))) {
            builder.add("asset", (Object)display.name$());
        }
        return builder;
    }

    private Frame frameOf(Dialog dialog) {
        return new FrameBuilder(new String[]{"dialog"}).add("name", (Object)dialog.name$()).add("package", (Object)this.packageName).toFrame();
    }

    private Template template() {
        return this.customize(new UIServiceTemplate());
    }

    private Template customize(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
        return template;
    }
}

