/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jmx;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jmx.JMXService;
import java.io.File;
import java.util.List;

public class JMXServerRenderer {
    private final List<JMXService> jmxServices;
    private final File destination;
    private final String packageName;
    private final String boxName;

    public JMXServerRenderer(KonosGraph graph, File destination, String packageName, String boxName) {
        this.jmxServices = graph.jMXServiceList();
        this.destination = destination;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.jmxServices.forEach(this::processService);
    }

    private void processService(JMXService service) {
        List<JMXService.Operation> operations = service.operationList();
        if (operations.isEmpty()) {
            return;
        }
        Commons.writeFrame(this.destination, "JMX" + StringHelper.snakeCaseToCamelCase((String)service.name$()), this.template().render((Object)new FrameBuilder(new String[]{"jmxserver"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).toFrame()));
    }

    private Template template() {
        return Formatters.customize(new JMXServerTemplate());
    }
}

