/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jms;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class JMSServiceTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("jms"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".requests.*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.jms.*;\n\nimport javax.jms.BytesMessage;\nimport javax.jms.JMSException;\nimport javax.jms.Session;\nimport javax.jms.Connection;\nimport javax.jms.TextMessage;\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\n\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Service {\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Configuration configuration;\n\tprivate javax.jms.Connection connection;\n\tprivate javax.jms.Session session;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Service(Connection connection, ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.configuration = box.configuration();\n\t\tthis.connection = connection;\n\t\tthis.session = createSession(connection);\n\t\tif (session == null) return;\n\t\t")}).output(new Rule.Output[]{this.mark("request", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("notification", new String[0]).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic javax.jms.Session session() {\n\t\treturn session;\n\t}\n\n\tpublic javax.jms.Connection connection() {\n\t\treturn connection;\n\t}\n\n\n\tpublic TopicProducer newTopicProducer(String path) {\n\t\ttry {\n\t\t\treturn new TopicProducer(session(), path);\n\t\t} catch (JMSException e) {\n\t\t\tLogger.getGlobal().severe(e.getMessage());\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic void closeSession() {\n\t\ttry {\n\t\t\tsession.close();\n\t\t} catch (JMSException e) {\n\t\t\tLogger.getGlobal().log(Level.SEVERE, e.getMessage(), e);\n\t\t}\n\t}\n\t\n\tprivate Session createSession(Connection connection) {\n\t\ttry {\n\t\t\treturn connection.createSession(false, Session.AUTO_ACKNOWLEDGE);\n\t\t} catch (JMSException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tprivate byte[] toByteArray(InputStream stream) {\n\t\ttry {\n\t\t\tByteArrayOutputStream buffer = new ByteArrayOutputStream();\n\t\t\tint nRead;\n\t\t\tbyte[] data = new byte[16384];\n\t\t\twhile ((nRead = stream.read(data, 0, data.length)) != -1) {\n\t\t\t\tbuffer.write(data, 0, nRead);\n\t\t\t}\n\t\t\tbuffer.flush();\n\t\t\treturn buffer.toByteArray();\n\t\t} catch (IOException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);\n\t\t}\n\t\treturn new byte[0];\n\t}\n}")}), this.rule().condition(this.type("request"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("new ")}).output(new Rule.Output[]{this.mark("model", new String[0])}).output(new Rule.Output[]{this.literal("Consumer(session, ")}).output(new Rule.Output[]{this.mark("queue", new String[]{"format"})}).output(new Rule.Output[]{this.literal(").listen(new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Request(box));")}), this.rule().condition(this.type("notification"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public void notify")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") throws JMSException {\n\tfinal ")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message message = session.create")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message();\n\tfill")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Message(message")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"name"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");\n\tnew ")}).output(new Rule.Output[]{this.mark("model", new String[0])}).output(new Rule.Output[]{this.literal("Producer(session, ")}).output(new Rule.Output[]{this.mark("queue", new String[]{"format"})}).output(new Rule.Output[]{this.literal(").produce(message);\n}\n\nprivate void fill")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Message(")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message message")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") throws JMSException {\n\t")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("queue"), new Rule.Condition[]{this.trigger("format")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("custom", new String[0]).multiple("")})}), this.rule().condition(this.trigger("custom"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal(".replace(\"{")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("}\", configuration.get(\"")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("\"))")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("signature")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.allTypes(new String[]{"parameter", "fileData"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.writeBytes(toByteArray(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.allTypes(new String[]{"parameter", "objectData"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.setText(new Gson().toJson(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.set")}).output(new Rule.Output[]{this.mark("type", new String[]{"formatted"})}).output(new Rule.Output[]{this.literal("Property(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("integer"), new Rule.Condition[]{this.trigger("formatted")}).output(new Rule.Output[]{this.literal("Int")})});
    }
}

