/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.messagehub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.DataHub;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import java.io.File;
import java.util.Map;

public class MessageHubRenderer {
    private final KonosGraph graph;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;
    private final File sourceDirectory;
    private final File genDirectory;

    public MessageHubRenderer(KonosGraph graph, File gen, File src, String packageName, String boxName, Map<String, String> classes) {
        this.graph = graph;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
        this.sourceDirectory = new File(src, "datahub");
        this.genDirectory = new File(gen, "datahub");
    }

    public void execute() {
        File destination;
        MessageHub messageHub = this.messageHub();
        if (messageHub == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messageHub"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName);
        if (messageHub.isJmsHub()) {
            builder.add("jms");
        }
        for (DataHub.Tank tank : this.graph.dataHub().tankList(r -> true)) {
            builder.add("tank", (Object)new FrameBuilder().add("name", (Object)tank.fullName().replace(".", "_")).add("qn", (Object)tank.fullName()));
        }
        this.classes.put("MessageHub", "datahub.MessageHub");
        File file = destination = messageHub.isJmsHub() ? this.genDirectory : this.sourceDirectory;
        if (!Commons.javaFile(destination, "MessageHub").exists()) {
            Commons.writeFrame(destination, "MessageHub", Formatters.customize(new MessageHubTemplate()).render((Object)builder.toFrame()));
        }
    }

    private MessageHub messageHub() {
        if (this.graph.dataHub() == null) {
            return null;
        }
        if (this.graph.dataHub().isMirrored()) {
            return this.graph.dataHub().asMirrored().messageHub();
        }
        if (this.graph.dataHub().isRemote()) {
            return this.graph.dataHub().asRemote().messageHub();
        }
        return null;
    }
}

