/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.adapter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.adapter.AdapterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Adapter;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.Map;

public class AdapterRenderer {
    private final List<Adapter> adapters;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public AdapterRenderer(KonosGraph graph, File src, String packageName, String boxName, Map<String, String> classes) {
        this.adapters = graph.dataHub().adapterList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Adapter adapter : this.adapters) {
            FrameBuilder builder = new FrameBuilder(new String[]{"adapter"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("name", (Object)adapter.name$());
            File directory = new File(this.src, "datahub/adapters");
            String adapterName = adapter.name$();
            this.classes.put(((Object)((Object)adapter)).getClass().getSimpleName() + "#" + adapter.name$(), "datahub.adapters." + adapterName);
            if (this.alreadyRendered(directory, adapterName)) continue;
            Commons.writeFrame(directory, adapterName, Formatters.customize(new AdapterTemplate()).render((Object)builder.toFrame()));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

