/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jmx;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class JMXAccessorRenderer {
    private final JMXService service;
    private File destination;
    private String packageName;

    public JMXAccessorRenderer(JMXService restService, File destination, String packageName) {
        this.service = restService;
        this.destination = new File(destination, "konos");
        this.packageName = packageName + ".konos";
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName, new HashMap<String, String>()).execute();
        this.createInterface(this.service);
        this.createService(this.service);
    }

    private void createInterface(JMXService service) {
        FrameBuilder frame = new FrameBuilder(new String[]{"jmx", "interface"});
        this.fillFrame(service, frame);
        Commons.writeFrame(this.destinationPackage(), service.name$() + "MBean", this.interfaceTemplate().render((Object)frame));
    }

    private File destinationPackage() {
        return new File(this.destination, "jmx");
    }

    private void createService(JMXService service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        this.fillFrame(service, builder);
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "JMXAccessor", this.template().render((Object)builder.toFrame()));
    }

    private void fillFrame(JMXService service, FrameBuilder builder) {
        builder.add("name", (Object)service.name$());
        builder.add("package", (Object)this.packageName);
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
        }
        for (JMXService.Operation operation : service.operationList()) {
            builder.add("operation", (Object)this.frameOf(operation));
        }
    }

    private Frame frameOf(JMXService.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"}).add("name", (Object)operation.name$()).add("action", (Object)operation.name$()).add("package", (Object)this.packageName).add("returnType", (Object)(operation.response() == null ? "void" : this.formatType(operation.response().asType())));
        this.setupParameters(operation.parameterList(), builder);
        return builder.toFrame();
    }

    private String formatType(TypeData typeData) {
        return (typeData.i$(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, FrameBuilder builder) {
        for (Parameter parameter : parameters) {
            builder.add("parameter", (Object)new FrameBuilder(new String[]{"parameter"}).add("name", (Object)parameter.name$()).add("type", (Object)this.formatType(parameter.asType())).toFrame());
        }
    }

    private Template template() {
        return Formatters.customize(new JMXAccessorTemplate());
    }

    private Template interfaceTemplate() {
        return Formatters.customize(new JMXServerTemplate());
    }
}

