/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.BoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Meta;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.ArrayList;

public class BoxRenderer {
    private final KonosGraph graph;
    private final File destination;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private boolean isTara;

    BoxRenderer(KonosGraph graph, File destination, String packageName, Module module, boolean isTara) {
        this.graph = graph;
        this.destination = destination;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.isTara = isTara;
    }

    public void execute() {
        String name = this.name();
        if (this.configuration == null || Commons.javaFile(this.destination, StringHelper.snakeCaseToCamelCase((String)name) + "Box").exists()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"Box"}).add("package", (Object)this.packageName).add("name", (Object)name);
        if (this.isTara) {
            builder.add("tara", (Object)this.fillTara());
        }
        DumbService.getInstance((Project)this.module.getProject()).setAlternativeResolveEnabled(true);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module.getProject());
        if (facade.findClass("io.intino.konos.server.ui.services.AuthService", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)) != null) {
            builder.add("rest", (Object)name);
        }
        if (this.hasAuthenticatedApis()) {
            builder.add("authenticationValidator", (Object)new FrameBuilder().add("type", (Object)"Basic"));
        }
        DumbService.getInstance((Project)this.module.getProject()).setAlternativeResolveEnabled(false);
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)name) + "Box", this.template().render((Object)builder.toFrame()));
    }

    private boolean hasAuthenticatedApis() {
        return this.graph.rESTServiceList().stream().anyMatch(restService -> restService.authenticatedWithToken() != null);
    }

    private Frame fillTara() {
        FrameBuilder builder = new FrameBuilder();
        builder.add("name", (Object)this.name());
        if (this.configuration.outLanguage() != null) {
            builder.add("outDSL", (Object)this.configuration.outLanguage());
        }
        builder.add("wrapper", (Object)this.dsls());
        return builder.toFrame();
    }

    private String[] dsls() {
        ArrayList<String> dsls = new ArrayList<String>();
        for (Configuration.LanguageLibrary lang : this.configuration.languages()) {
            if (Meta.class.getSimpleName().equals(lang.name()) || Proteo.class.getSimpleName().equals(lang.name())) continue;
            String genPackage = lang.generationPackage();
            dsls.add((genPackage == null ? "" : genPackage.toLowerCase() + ".") + Formatters.firstUpperCase(lang.name()));
        }
        if (this.configuration.level() != Configuration.Level.Solution) {
            dsls.add(this.configuration.workingPackage().toLowerCase() + "." + Formatters.firstUpperCase(this.configuration.outLanguage()));
        }
        return dsls.toArray(new String[0]);
    }

    private Template template() {
        return Formatters.customize(new BoxTemplate());
    }

    private String name() {
        return this.module != null ? this.configuration.artifactId() : Configuration.Level.Solution.name();
    }
}

