/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.population;

import io.intino.konos.model.graph.DataHub;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.constant.population.mounter.ConstantColumn;
import io.intino.konos.model.graph.id.population.mounter.IdColumn;
import io.intino.konos.model.graph.mountertype.MounterTypeMounter;
import io.intino.konos.model.graph.set.datahub.SetTank;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PopulationMounter
extends MounterTypeMounter
implements Terminal {
    protected List<Column> columnList = new ArrayList<Column>();
    protected Filter filter;
    protected Aggregation aggregation;
    protected Collect collect;

    public PopulationMounter(Node node) {
        super(node);
    }

    public List<Column> columnList() {
        return Collections.unmodifiableList(this.columnList);
    }

    public Column column(int index) {
        return this.columnList.get(index);
    }

    public List<Column> columnList(Predicate<Column> predicate) {
        return this.columnList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Filter filter() {
        return this.filter;
    }

    public Aggregation aggregation() {
        return this.aggregation;
    }

    public Collect collect() {
        return this.collect;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
        if (this.filter != null) {
            components.add(this.filter.core$());
        }
        if (this.aggregation != null) {
            components.add(this.aggregation.core$());
        }
        if (this.collect != null) {
            components.add(this.collect.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Population#Mounter$Column")) {
            this.columnList.add((Column)node.as(Column.class));
        }
        if (node.is("Population#Mounter$Filter")) {
            this.filter = (Filter)node.as(Filter.class);
        }
        if (node.is("Population#Mounter$Aggregation")) {
            this.aggregation = (Aggregation)node.as(Aggregation.class);
        }
        if (node.is("Population#Mounter$Collect")) {
            this.collect = (Collect)node.as(Collect.class);
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Population#Mounter$Column")) {
            this.columnList.remove(node.as(Column.class));
        }
        if (node.is("Population#Mounter$Filter")) {
            this.filter = null;
        }
        if (node.is("Population#Mounter$Aggregation")) {
            this.aggregation = null;
        }
        if (node.is("Population#Mounter$Collect")) {
            this.collect = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        this._mounter.core$().load((Layer)this._mounter, name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        this._mounter.core$().set((Layer)this._mounter, name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Collect
    extends Layer
    implements Terminal {
        protected Datamart datamart;
        protected Format format;

        public Collect(Node node) {
            super(node);
        }

        public Datamart datamart() {
            return this.datamart;
        }

        public Format format() {
            return this.format;
        }

        public Collect datamart(Datamart value) {
            this.datamart = value;
            return this;
        }

        public Collect format(Format value) {
            this.format = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("datamart", this.datamart != null ? new ArrayList<Datamart>(Collections.singletonList(this.datamart)) : Collections.emptyList());
            map.put("format", new ArrayList<Format>(Collections.singletonList(this.format)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("datamart")) {
                this.datamart = (Datamart)((Object)NodeLoader.load(values, Datamart.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("format")) {
                this.format = (Format)((Object)WordLoader.load(values, Format.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("datamart")) {
                this.datamart = values.get(0) != null ? (Datamart)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Datamart.class) : null;
            } else if (name.equalsIgnoreCase("format")) {
                this.format = (Format)((Object)values.get(0));
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Format {
            Arff,
            Tabb,
            Csv;

        }
    }

    public static class Aggregation
    extends Layer
    implements Terminal {
        protected List<Column> columnList = new ArrayList<Column>();

        public Aggregation(Node node) {
            super(node);
        }

        public List<Column> columnList() {
            return Collections.unmodifiableList(this.columnList);
        }

        public Column column(int index) {
            return this.columnList.get(index);
        }

        public List<Column> columnList(Predicate<Column> predicate) {
            return this.columnList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Population#Mounter$Aggregation$Column")) {
                this.columnList.add((Column)node.as(Column.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Population#Mounter$Aggregation$Column")) {
                this.columnList.remove(node.as(Column.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Column
        extends Layer
        implements Terminal {
            protected String name;
            protected DataHub.Tank tank;
            protected Type type;

            public Column(Node node) {
                super(node);
            }

            public String name() {
                return this.name;
            }

            public DataHub.Tank tank() {
                return this.tank;
            }

            public Type type() {
                return this.type;
            }

            public Column name(String value) {
                this.name = value;
                return this;
            }

            public Column tank(DataHub.Tank value) {
                this.tank = value;
                return this;
            }

            public Column type(Type value) {
                this.type = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("tank", this.tank != null ? new ArrayList<DataHub.Tank>(Collections.singletonList(this.tank)) : Collections.emptyList());
                map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("tank")) {
                    this.tank = (DataHub.Tank)((Object)NodeLoader.load(values, DataHub.Tank.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("tank")) {
                    this.tank = values.get(0) != null ? (DataHub.Tank)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(DataHub.Tank.class) : null;
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)values.get(0));
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum Type {
                Boolean,
                String,
                Integer,
                Double,
                Nominal,
                Datetime,
                Instant,
                Long,
                Timetag;

            }
        }

        public class Clear {
            public void column(Predicate<Column> filter) {
                new ArrayList<Column>(Aggregation.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Column column(String name, DataHub.Tank tank, Column.Type type) {
                Column newElement = (Column)Aggregation.this.core$().graph().concept(Column.class).createNode(this.name, Aggregation.this.core$()).as(Column.class);
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
                newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }
        }
    }

    public static class Filter
    extends Layer
    implements Terminal {
        public Filter(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Column
    extends Layer
    implements Terminal {
        protected SetTank tank;
        protected Type type;

        public Column(Node node) {
            super(node);
        }

        public SetTank tank() {
            return this.tank;
        }

        public Type type() {
            return this.type;
        }

        public Column tank(SetTank value) {
            this.tank = value;
            return this;
        }

        public Column type(Type value) {
            this.type = value;
            return this;
        }

        public ConstantColumn asConstant() {
            return (ConstantColumn)this.a$(ConstantColumn.class);
        }

        public ConstantColumn asConstant(String value) {
            ConstantColumn newElement = (ConstantColumn)this.core$().addFacet(ConstantColumn.class);
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public boolean isConstant() {
            return this.core$().is(ConstantColumn.class);
        }

        public void removeConstant() {
            this.core$().removeFacet(ConstantColumn.class);
        }

        public IdColumn asId() {
            Layer as = this.a$(IdColumn.class);
            return as != null ? (IdColumn)as : (IdColumn)this.core$().addFacet(IdColumn.class);
        }

        public boolean isId() {
            return this.core$().is(IdColumn.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tank", this.tank != null ? new ArrayList<SetTank>(Collections.singletonList(this.tank)) : Collections.emptyList());
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (SetTank)((Object)NodeLoader.load(values, SetTank.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = values.get(0) != null ? (SetTank)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(SetTank.class) : null;
            } else if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Type {
            Boolean,
            String,
            Integer,
            Double,
            Nominal,
            Datetime,
            Instant,
            Long,
            Timetag;

        }
    }

    public class Clear {
        public void column(Predicate<Column> filter) {
            new ArrayList<Column>(PopulationMounter.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends MounterTypeMounter.Create {
        public Create(String name) {
            super(name);
        }

        public Column column(SetTank tank, Column.Type type) {
            Column newElement = (Column)PopulationMounter.this.core$().graph().concept(Column.class).createNode(this.name, PopulationMounter.this.core$()).as(Column.class);
            newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Filter filter() {
            Filter newElement = (Filter)PopulationMounter.this.core$().graph().concept(Filter.class).createNode(this.name, PopulationMounter.this.core$()).as(Filter.class);
            return newElement;
        }

        public Aggregation aggregation() {
            Aggregation newElement = (Aggregation)PopulationMounter.this.core$().graph().concept(Aggregation.class).createNode(this.name, PopulationMounter.this.core$()).as(Aggregation.class);
            return newElement;
        }

        public Collect collect(Datamart datamart, Collect.Format format) {
            Collect newElement = (Collect)PopulationMounter.this.core$().graph().concept(Collect.class).createNode(this.name, PopulationMounter.this.core$()).as(Collect.class);
            newElement.core$().set((Layer)newElement, "datamart", Collections.singletonList(datamart));
            newElement.core$().set((Layer)newElement, "format", Collections.singletonList(format));
            return newElement;
        }
    }
}

