/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Broker
extends Layer
implements Component,
Terminal {
    protected Location location;
    protected int port;
    protected int mqtt_port;
    protected String connectorId;
    protected List<User> userList = new ArrayList<User>();
    protected List<Pipe> pipeList = new ArrayList<Pipe>();

    public Broker(Node node) {
        super(node);
    }

    public Location location() {
        return this.location;
    }

    public int port() {
        return this.port;
    }

    public int mqtt_port() {
        return this.mqtt_port;
    }

    public String connectorId() {
        return this.connectorId;
    }

    public Broker location(Location value) {
        this.location = value;
        return this;
    }

    public Broker port(int value) {
        this.port = value;
        return this;
    }

    public Broker mqtt_port(int value) {
        this.mqtt_port = value;
        return this;
    }

    public Broker connectorId(String value) {
        this.connectorId = value;
        return this;
    }

    public List<User> userList() {
        return Collections.unmodifiableList(this.userList);
    }

    public User user(int index) {
        return this.userList.get(index);
    }

    public List<User> userList(Predicate<User> predicate) {
        return this.userList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Pipe> pipeList() {
        return Collections.unmodifiableList(this.pipeList);
    }

    public Pipe pipe(int index) {
        return this.pipeList.get(index);
    }

    public List<Pipe> pipeList(Predicate<Pipe> predicate) {
        return this.pipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<User>(this.userList).forEach(c -> components.add(c.core$()));
        new ArrayList<Pipe>(this.pipeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("location", new ArrayList<Location>(Collections.singletonList(this.location)));
        map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
        map.put("mqtt_port", new ArrayList<Integer>(Collections.singletonList(this.mqtt_port)));
        map.put("connectorId", new ArrayList<String>(Collections.singletonList(this.connectorId)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Broker$User")) {
            this.userList.add((User)node.as(User.class));
        }
        if (node.is("Broker$Pipe")) {
            this.pipeList.add((Pipe)node.as(Pipe.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Broker$User")) {
            this.userList.remove(node.as(User.class));
        }
        if (node.is("Broker$Pipe")) {
            this.pipeList.remove(node.as(Pipe.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("location")) {
            this.location = (Location)((Object)WordLoader.load(values, Location.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mqtt_port")) {
            this.mqtt_port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("connectorId")) {
            this.connectorId = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("location")) {
            this.location = (Location)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("mqtt_port")) {
            this.mqtt_port = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("connectorId")) {
            this.connectorId = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Pipe
    extends Layer
    implements Terminal {
        protected String origin;
        protected String destination;

        public Pipe(Node node) {
            super(node);
        }

        public String origin() {
            return this.origin;
        }

        public String destination() {
            return this.destination;
        }

        public Pipe origin(String value) {
            this.origin = value;
            return this;
        }

        public Pipe destination(String value) {
            this.destination = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("origin", new ArrayList<String>(Collections.singletonList(this.origin)));
            map.put("destination", new ArrayList<String>(Collections.singletonList(this.destination)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("origin")) {
                this.origin = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("destination")) {
                this.destination = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("origin")) {
                this.origin = (String)values.get(0);
            } else if (name.equalsIgnoreCase("destination")) {
                this.destination = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class User
    extends Layer
    implements Terminal {
        protected String name;
        protected String password;

        public User(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public String password() {
            return this.password;
        }

        public User name(String value) {
            this.name = value;
            return this;
        }

        public User password(String value) {
            this.password = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void user(Predicate<User> filter) {
            new ArrayList<User>(Broker.this.userList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void pipe(Predicate<Pipe> filter) {
            new ArrayList<Pipe>(Broker.this.pipeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public User user(String name, String password) {
            User newElement = (User)Broker.this.core$().graph().concept(User.class).createNode(this.name, Broker.this.core$()).as(User.class);
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
            return newElement;
        }

        public Pipe pipe(String origin, String destination) {
            Pipe newElement = (Pipe)Broker.this.core$().graph().concept(Pipe.class).createNode(this.name, Broker.this.core$()).as(Pipe.class);
            newElement.core$().set((Layer)newElement, "origin", Collections.singletonList(origin));
            newElement.core$().set((Layer)newElement, "destination", Collections.singletonList(destination));
            return newElement;
        }
    }

    public static enum Location {
        Embed,
        Remote;

    }
}

