/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.task;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.datahub.feeder.FeederRenderer;
import io.intino.konos.builder.codegeneration.task.TaskTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Task;
import io.intino.konos.model.graph.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.graph.scheduled.ScheduledTask;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TaskRenderer {
    private final List<ScheduledTask> scheduledTasks;
    private final List<Task> tasks;
    private final String boxName;
    private File srcDestination;
    private File genDestination;
    private String packageName;

    public TaskRenderer(KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.scheduledTasks = graph.scheduledTaskList();
        this.tasks = graph.taskList().stream().filter(t -> !t.isScheduled()).collect(Collectors.toList());
        this.srcDestination = src;
        this.genDestination = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.scheduledTasks.forEach(this::processTrigger);
        this.tasks.stream().filter(Task::isDirectorySentinel).forEach(this::processDirectorySentinel);
    }

    private void processTrigger(ScheduledTask task) {
        boolean hasTargets;
        FrameBuilder builder = this.baseFrame("task").add("name", (Object)task.name$());
        List<Frame> targets = this.targets(task);
        boolean bl = hasTargets = !targets.isEmpty();
        if (!hasTargets) {
            targets.add(this.baseFrame(task.name$()).add("name", (Object)task.name$()).toFrame());
        }
        builder.add("target", (Object)targets.toArray(new Frame[0]));
        Commons.writeFrame(this.destinyPackage(), task.name$() + "Task", this.template().render((Object)builder.toFrame()));
        if (!hasTargets) {
            this.createCorrespondingAction(task);
        }
    }

    private List<Frame> targets(ScheduledTask task) {
        List<Frame> frames = task.linkWithMounterList().stream().map(link -> this.baseFrame("target", "mounter").add("name", (Object)link.mounter().name$()).toFrame()).collect(Collectors.toList());
        task.linkWithFeederList().stream().map(link -> this.baseFrame("target", "feeder").add("name", (Object)FeederRenderer.name(link.feeder())).toFrame()).forEach(frames::add);
        return frames;
    }

    private void processDirectorySentinel(Task task) {
        FrameBuilder frame = new FrameBuilder(new String[]{"task"}).add("name", (Object)task.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("parameter", (Object)this.parameters(task.asDirectorySentinel()));
        if (!this.alreadyRendered(this.srcDestination, task)) {
            Commons.writeFrame(this.actionsPackage(this.srcDestination), task.name$() + "Action", this.actionTemplate().render((Object)frame));
        }
    }

    private Frame[] parameters(DirectorySentinelTask task) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)URL.class.getCanonicalName()).add("name", (Object)"directory").toFrame());
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)"io.intino.konos.scheduling.directory.KonosDirectorySentinel.Event").add("name", (Object)"event").toFrame());
        return list.toArray(new Frame[0]);
    }

    private void createCorrespondingAction(ScheduledTask task) {
        if (!this.alreadyRendered(this.srcDestination, (Task)task.a$(Task.class))) {
            Commons.writeFrame(this.actionsPackage(this.srcDestination), task.name$() + "Action", this.actionTemplate().render((Object)new FrameBuilder(new String[]{"action"}).add("name", (Object)task.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).toFrame()));
        }
    }

    private Template actionTemplate() {
        return Formatters.customize(new ActionTemplate());
    }

    private Template template() {
        return Formatters.customize(new TaskTemplate());
    }

    private boolean alreadyRendered(File destiny, Task task) {
        return Commons.javaFile(this.actionsPackage(destiny), task.name$() + "Action").exists();
    }

    private File actionsPackage(File destiny) {
        return new File(destiny, "actions");
    }

    private File destinyPackage() {
        return new File(this.genDestination, "scheduling");
    }

    @NotNull
    private FrameBuilder baseFrame(String ... types) {
        FrameBuilder frameBuilder = new FrameBuilder(types).add("box", (Object)this.boxName).add("package", (Object)this.packageName);
        if (frameBuilder == null) {
            TaskRenderer.$$$reportNull$$$0(0);
        }
        return frameBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/task/TaskRenderer", "baseFrame"));
    }
}

