/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.task;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.task.SchedulerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Task;
import io.intino.konos.model.graph.boottrigger.BootTriggerTask;
import io.intino.konos.model.graph.crontrigger.CronTriggerTask;
import io.intino.konos.model.graph.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.graph.scheduled.ScheduledTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SchedulerRenderer {
    private final List<Task> tasks;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public SchedulerRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.tasks = graph.taskList();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        if (this.tasks.isEmpty()) {
            return;
        }
        Commons.writeFrame(this.gen, "Tasks", this.template().render((Object)new FrameBuilder(new String[]{"scheduler"}).add("package", (Object)this.packageName).add("box", (Object)this.boxName).add("task", (Object)this.processTasks(this.tasks)).toFrame()));
    }

    private Frame[] processTasks(List<Task> tasks) {
        ArrayList list = new ArrayList();
        list.addAll(tasks.stream().filter(t -> t.i$(ScheduledTask.class)).map(t -> (ScheduledTask)t.a$(ScheduledTask.class)).map(this::processTask).collect(Collectors.toList()));
        list.addAll(tasks.stream().filter(t -> t.i$(DirectorySentinelTask.class)).map(t -> (DirectorySentinelTask)t.a$(DirectorySentinelTask.class)).map(this::processDirectorySentinel).collect(Collectors.toList()));
        return list.toArray(new Frame[0]);
    }

    private Frame processTask(ScheduledTask task) {
        FrameBuilder builder = new FrameBuilder().add("task").add(((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.name$());
        ArrayList<Frame> jobFrames = new ArrayList<Frame>();
        if (task.i$(CronTriggerTask.class)) {
            CronTriggerTask cron = (CronTriggerTask)task.a$(CronTriggerTask.class);
            FrameBuilder jobFrameBuilder = new FrameBuilder().add("job").add("Cron" + ((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.core$().id());
            jobFrameBuilder.add("cronTrigger").add("pattern", (Object)cron.pattern()).add("mean", (Object)cron.mean());
            if (cron.timeZone() != null) {
                jobFrameBuilder.add("timeZone", (Object)cron.timeZone());
            }
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        if (task.i$(BootTriggerTask.class)) {
            FrameBuilder jobFrameBuilder = new FrameBuilder(new String[]{"onBootTrigger", "job", "Boot" + ((Object)((Object)task)).getClass().getSimpleName()}).add("name", (Object)task.core$().id());
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        builder.add("job", (Object)jobFrames.toArray(new Frame[0]));
        return builder.toFrame();
    }

    private Frame processDirectorySentinel(DirectorySentinelTask task) {
        FrameBuilder builder = new FrameBuilder().add("task").add(((Object)((Object)task)).getClass().getSimpleName()).add("event", task.events().stream().map(Enum::name).toArray(String[]::new)).add("file", (Object)(task.directory() == null ? "" : task.directory())).add("name", (Object)task.name$()).add("package", (Object)this.packageName);
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new SchedulerTemplate());
    }
}

