/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.toolbar;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIPrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.AbstractOperationTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationTemplate;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Component;
import io.intino.tara.magritte.Layer;
import java.io.File;

public class OperationRenderer
extends UIPrototypeRenderer {
    private final AbstractToolbar.Operation operation;
    private final Component owner;

    public OperationRenderer(AbstractToolbar.Operation operation, Component owner, String box, String packageName) {
        super(operation.name$(), box, packageName);
        this.operation = operation;
        this.owner = owner;
    }

    @Override
    public FrameBuilder frameBuilder() {
        FrameBuilder builder = super.frameBuilder().add("operation").add(((Object)((Object)this.operation)).getClass().getSimpleName()).add("title", (Object)this.operation.title()).add("owner", (Object)this.owner.name$()).add("ownerClass", (Object)((Object)((Object)this.owner)).getClass().getSimpleName()).add("mode", (Object)this.operation.mode().toString());
        if (this.owner.i$(Catalog.class)) {
            builder.add("itemClass", (Object)((Catalog)this.owner.a$(Catalog.class)).itemClass());
        }
        if (this.operation.polymerIcon() != null) {
            builder.add("icon", (Object)this.operation.polymerIcon());
        }
        this.addTaskProperties(builder);
        this.addTaskSelectionProperties(builder);
        this.addOpenDialogProperties(builder);
        this.addOpenCatalogProperties(builder);
        this.addOpenCatalogSelectionProperties(builder);
        return builder;
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(new OperationTemplate());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(new AbstractOperationTemplate());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return null;
    }

    private void addTaskProperties(FrameBuilder builder) {
        if (!this.operation.i$(AbstractToolbar.Task.class)) {
            return;
        }
        AbstractToolbar.Task task = (AbstractToolbar.Task)this.operation.a$(AbstractToolbar.Task.class);
        if (task.confirmText() == null) {
            return;
        }
        builder.add("confirmText", (Object)task.confirmText());
    }

    private void addTaskSelectionProperties(FrameBuilder builder) {
        if (!this.operation.i$(AbstractToolbar.TaskSelection.class)) {
            return;
        }
        AbstractToolbar.TaskSelection taskSelection = (AbstractToolbar.TaskSelection)this.operation.a$(AbstractToolbar.TaskSelection.class);
        if (taskSelection.confirmText() == null) {
            return;
        }
        builder.add("confirmText", (Object)taskSelection.confirmText());
    }

    private void addOpenDialogProperties(FrameBuilder builder) {
        if (!this.operation.i$(AbstractToolbar.OpenDialog.class)) {
            return;
        }
        builder.add("dialog", (Object)((AbstractToolbar.OpenDialog)this.operation.a$(AbstractToolbar.OpenDialog.class)).dialog().name$());
    }

    private void addOpenCatalogProperties(FrameBuilder builder) {
        if (!this.operation.i$(AbstractToolbar.OpenCatalog.class)) {
            return;
        }
        AbstractToolbar.OpenCatalog openCatalog = (AbstractToolbar.OpenCatalog)this.operation.a$(AbstractToolbar.OpenCatalog.class);
        builder.add("width", (Object)openCatalog.width());
        builder.add("height", (Object)openCatalog.height());
        builder.add("position", (Object)openCatalog.position().toString());
        builder.add("openCatalog", (Object)openCatalog.catalog().name$());
        builder.add("view", openCatalog.views().stream().map(Layer::name$).toArray(String[]::new));
        if (openCatalog.filtered()) {
            builder.add("openCatalogOperationFilter", (Object)new FrameBuilder().add("owner", (Object)this.owner.name$()).add("ownerClass", (Object)((Object)((Object)this.owner)).getClass().getSimpleName()).add("box", (Object)this.box));
        }
    }

    private void addOpenCatalogSelectionProperties(FrameBuilder builder) {
        if (!this.operation.i$(AbstractToolbar.OpenCatalogSelection.class)) {
            return;
        }
        String itemClass = ((Catalog)this.owner.a$(Catalog.class)).itemClass();
        AbstractToolbar.OpenCatalogSelection openCatalogSelection = (AbstractToolbar.OpenCatalogSelection)this.operation.a$(AbstractToolbar.OpenCatalogSelection.class);
        builder.add("width", (Object)openCatalogSelection.width());
        builder.add("height", (Object)openCatalogSelection.height());
        builder.add("position", (Object)openCatalogSelection.position().toString());
        builder.add("openCatalog", (Object)openCatalogSelection.catalog().name$());
        builder.add("view", openCatalogSelection.views().stream().map(Layer::name$).toArray(String[]::new));
        builder.add("selection", (Object)openCatalogSelection.selection().toString());
        if (openCatalogSelection.filtered()) {
            builder.add("openCatalogSelectionOperationFilter", (Object)new FrameBuilder().add("owner", (Object)this.owner.name$()).add("ownerClass", (Object)((Object)((Object)this.owner)).getClass().getSimpleName()).add("box", (Object)this.box).add("itemClass", (Object)itemClass));
        }
        builder.add("openCatalogSelectionOperation", (Object)new FrameBuilder().add("owner", (Object)this.owner.name$()).add("ownerClass", (Object)((Object)((Object)this.owner)).getClass().getSimpleName()).add("box", (Object)this.box).add("itemClass", (Object)itemClass));
    }
}

