/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplaysTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class DisplaysRenderer
extends UIRenderer {
    private final File gen;
    private final List<Display> displays;

    public DisplaysRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        super(boxName, packageName);
        this.gen = gen;
        this.displays = graph.displayList().stream().filter(d -> !((Object)d).getClass().equals(Display.class)).collect(Collectors.toList());
    }

    public void execute() {
        if (this.displays.isEmpty()) {
            return;
        }
        FrameBuilder builder = this.frameBuilder().add("display", this.displays.stream().map(this::displayFrame).toArray(Frame[]::new));
        this.write(builder.toFrame());
    }

    private Frame displayFrame(Display display) {
        return new FrameBuilder(new String[]{"display"}).add("name", (Object)display.name$()).add("type", (Object)((Object)((Object)display)).getClass().getSimpleName()).toFrame();
    }

    private void write(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)"Displays");
        Commons.writeFrame(new File(this.gen, "displays"), newDisplay, this.template().render((Object)frame));
    }

    private Template template() {
        return Formatters.customize(new DisplaysTemplate());
    }

    @Override
    protected FrameBuilder frameBuilder() {
        return super.frameBuilder().add("displays");
    }
}

