/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;

public abstract class UIPrototypeRenderer
extends UIRenderer {
    private final String name;

    protected UIPrototypeRenderer(String name, String box, String packageName) {
        super(box, packageName);
        this.name = name;
    }

    @Override
    public FrameBuilder frameBuilder() {
        return super.frameBuilder().add("name", (Object)this.name);
    }

    public final void write(File src, File gen) {
        FrameBuilder frameBuilder = this.frameBuilder();
        this.writeSrc(src, frameBuilder);
        this.writeGen(gen, frameBuilder);
    }

    private void writeSrc(File file, FrameBuilder builder) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.name);
        File sourceFile = Commons.javaFile(new File(file, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(file, "displays"), newDisplay, this.srcTemplate().render((Object)builder.toFrame()));
        } else {
            Updater updater = this.updater(newDisplay, sourceFile);
            if (updater != null) {
                updater.update();
            }
        }
    }

    private void writeGen(File file, FrameBuilder builder) {
        String name = StringHelper.snakeCaseToCamelCase((String)("Abstract" + Commons.firstUpperCase(this.name)));
        Commons.writeFrame(new File(file, "displays"), name, this.genTemplate().render((Object)builder.add("gen").toFrame()));
    }

    protected abstract Template srcTemplate();

    protected abstract Template genTemplate();

    protected abstract Updater updater(String var1, File var2);
}

