/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jms;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class JMSRequestTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("request"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".requests;\n\nimport io.intino.alexandria.exceptions.*;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".*;\nimport com.google.gson.Gson;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.jms.RequestConsumer;\n\nimport javax.jms.*;\nimport java.util.List;\nimport java.util.logging.Level;\nimport java.util.logging.Logger;\n")}).output(new Rule.Output[]{this.mark("schemaImport", new String[0])}).output(new Rule.Output[]{this.literal("\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Request implements RequestConsumer {\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Request(")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.box = box;\n\t}\n\n\tpublic void consume(Session session, Message request) {\n\t\ttry {\n\t\t\t")}).output(new Rule.Output[]{this.mark("call", new String[0])}).output(new Rule.Output[]{this.literal("\n\t\t} ")}).output(new Rule.Output[]{this.mark("exception", new String[]{"catch"})}).output(new Rule.Output[]{this.literal("\n\t\tcatch (Throwable e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);\n\t\t}\n\t}\n\n\tprivate ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action actionFor(Message message) {\n\t\tfinal ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action action = new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action();\n\t\taction.box = this.box;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("try {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("} catch (JMSException e) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n\t\treturn action;\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("private Message responseMessage(Session session, String responseId, ")}).output(new Rule.Output[]{this.mark("returnType", new String[0])}).output(new Rule.Output[]{this.literal(" response) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\ttry {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\t")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message message = session.create")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\tmessage.setJMSCorrelationID(responseId);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\t")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[]{"return"})}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\treturn message;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t} catch (JMSException e) {")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t\treturn null;")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("\t}")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("}")})}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.attribute("bytes"), new Rule.Condition[]{this.trigger("return")}).output(new Rule.Output[]{this.literal("message.writeBytes(toByteArray(response));")}), this.rule().condition(this.trigger("return"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("message.set")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("(new Gson().toJson(response));")}), this.rule().condition(this.not(this.type("void")), new Rule.Condition[]{this.trigger("call")}).output(new Rule.Output[]{this.literal("response(session, replyTo(request), responseMessage(session, idOf(request), actionFor(request).execute()));")}), this.rule().condition(this.trigger("call"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("actionFor(request).execute();")}), this.rule().condition(this.trigger("catch"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("catch (AlexandriaException e) {\n\tresponse(session, replyTo(request), exceptionMessage(session, idOf(request), e));\n}")}), this.rule().condition(this.allTypes(new String[]{"parameter", "filedata"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("byte[] data = new byte[(int) ((BytesMessage) message).getBodyLength()];\n((BytesMessage) message).readBytes(data);\naction.")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = toInputStream(data);")}), this.rule().condition(this.allTypes(new String[]{"objectdata", "parameter"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("action.")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = new Gson().fromJson(((TextMessage) message).getText(), ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class);")}), this.rule().condition(this.allTypes(new String[]{"parameter", "list"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("action.")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = new Gson().fromJson(message.getStringProperty(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"),  new com.google.gson.reflect.TypeToken<java.util.ArrayList<")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(">>(){}.getType());")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("action.")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = message.get")}).output(new Rule.Output[]{this.mark("type", new String[]{"format"})}).output(new Rule.Output[]{this.literal("Property(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.attribute("integer"), new Rule.Condition[]{this.trigger("format")}).output(new Rule.Output[]{this.literal("Int")}), this.rule().condition(this.type("schemaimport"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".schemas.*;")})});
    }
}

