/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.main;

import com.intellij.openapi.module.Module;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.main.MainTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;

public class MainRenderer {
    private final File destination;
    private final boolean hasModel;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;

    public MainRenderer(File destination, boolean hasModel, String packageName, Module module) {
        this.destination = destination;
        this.hasModel = hasModel;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
    }

    public void execute() {
        if (this.configuration == null) {
            return;
        }
        String name = this.name();
        FrameBuilder builder = new FrameBuilder(new String[]{"main"}).add("package", (Object)this.packageName).add("name", (Object)name);
        if (this.hasModel) {
            builder.add("model", (Object)new FrameBuilder(new String[]{"model"}).add("name", (Object)name).toFrame());
        }
        if (!Commons.javaFile(this.destination, "Main").exists()) {
            Commons.writeFrame(this.destination, "Main", this.template().render((Object)builder.toFrame()));
        }
    }

    private Template template() {
        return Formatters.customize(new MainTemplate());
    }

    private String name() {
        return this.module != null ? this.configuration.artifactId() : Configuration.Level.Solution.name();
    }
}

