/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.process;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.process.ProcessTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Procedure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProcessRenderer {
    private final List<Procedure.Process> processes;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public ProcessRenderer(KonosGraph graph, File src, String packageName, String boxName, Map<String, String> classes) {
        this.processes = this.processes(graph);
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Procedure.Process process : this.processes) {
            String procedure = ((Procedure)process.core$().ownerAs(Procedure.class)).name$();
            String name = this.composedName(process);
            FrameBuilder builder = new FrameBuilder(new String[]{"process"}).add("box", (Object)this.boxName).add("procedure", (Object)procedure).add("package", (Object)this.packageName).add("name", (Object)name);
            if (process.input().schema() != null) {
                builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName).toFrame());
                builder.add("type", (Object)new FrameBuilder(new String[]{"schema"}).add("package", (Object)this.packageName).add("name", (Object)process.input().schema().name$()).toFrame());
            } else {
                builder.add("type", (Object)"message");
            }
            File destination = new File(this.src, "procedures" + File.separator + procedure.toLowerCase());
            String handlerName = Commons.firstUpperCase(name) + "Process";
            this.classes.put(((Object)((Object)process)).getClass().getSimpleName() + "#" + process.name$(), "procedures." + procedure.toLowerCase() + "." + handlerName);
            if (this.alreadyRendered(destination, handlerName)) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(new ProcessTemplate()).render((Object)builder.toFrame()));
        }
    }

    private String composedName(Procedure.Process process) {
        return Commons.firstUpperCase((process.input().subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)process.input().subdomain().replace(".", "_"))) + Commons.firstUpperCase(process.name$()));
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private List<Procedure.Process> processes(KonosGraph graph) {
        if (graph == null) {
            return Collections.emptyList();
        }
        return graph.procedureList().stream().map(Procedure::processList).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

