/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.population.PopulationMounter;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MounterRenderer {
    private final List<Mounter> mounters;
    private final File gen;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public MounterRenderer(KonosGraph graph, File gen, File src, String packageName, String boxName, Map<String, String> classes) {
        this.mounters = graph.dataHub().mounterList();
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("name", (Object)mounter.name$());
            if (mounter.isPopulation()) {
                this.populationMounter(builder, mounter.asPopulation());
                this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datahub.mounters." + mounter.name$() + "Mounter");
                Commons.writeFrame(new File(this.gen, "datahub/mounters"), mounter.name$() + "Mounter", Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
                Commons.writeFrame(new File(this.src, "datahub/mounters"), mounter.name$() + "MounterFunctions", Formatters.customize(new MounterTemplate()).render((Object)builder.add("src").toFrame()));
                continue;
            }
            if (!mounter.isRealtime()) {
                Commons.writeFrame(new File(this.src, "datahub/mounters"), mounter.name$() + "Mounter", Formatters.customize(new MounterTemplate()).render((Object)builder.add("batch").toFrame()));
                continue;
            }
            this.realtimeMounter(builder, mounter);
            File destination = new File(this.src, "datahub/mounters");
            String mounterName = mounter.name$() + "Mounter";
            this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datahub.mounters." + mounterName);
            if (this.alreadyRendered(destination, mounterName)) continue;
            Commons.writeFrame(destination, mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        }
    }

    private void populationMounter(FrameBuilder builder, PopulationMounter mounter) {
        List<PopulationMounter.Column> splittedColumns = mounter.columnList().stream().filter(c -> c.tank().split() != null).collect(Collectors.toList());
        if (!splittedColumns.isEmpty()) {
            builder.add("population").add("splittedColumns", (Object)this.splitted(splittedColumns));
        }
        builder.add("column", mounter.columnList().stream().map(column -> this.builderOf((PopulationMounter.Column)((Object)column)).toFrame()).toArray(Frame[]::new));
        builder.add("datamart", (Object)mounter.collect().datamart().name$());
        builder.add("format", (Object)mounter.collect().format().name());
    }

    private Frame splitted(List<PopulationMounter.Column> splittedColumns) {
        return new FrameBuilder(new String[]{"splittedColumns"}).add("column", splittedColumns.stream().map(column -> this.builderOf((PopulationMounter.Column)((Object)column)).add("splitted").toFrame()).toArray(Frame[]::new)).toFrame();
    }

    private FrameBuilder builderOf(PopulationMounter.Column column) {
        FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("fullName", (Object)column.tank().fullName()).add("name", (Object)column.tank().name$()).add("type", (Object)column.type().name()).add("mounter", (Object)((Mounter)column.core$().ownerAs(Mounter.class)).name$());
        if (column.isId()) {
            builder.add("facet", (Object)"id");
        }
        return builder;
    }

    private void realtimeMounter(FrameBuilder builder, Mounter mounter) {
        builder.add("realtime");
        if (mounter.asRealtime().selectList().size() == 1) {
            Schema schema = mounter.asRealtime().select(0).tank().asEvent().schema();
            if (schema != null) {
                builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
                builder.add("type", (Object)new FrameBuilder(new String[]{"schema"}).add("package", (Object)this.packageName).add("name", (Object)schema.name$()));
            } else {
                builder.add("type", (Object)"message");
            }
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

