/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.action.ActionUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.List;

abstract class ActionRenderer {
    protected final Project project;
    protected final File destiny;
    protected final String boxName;
    private final String type;
    protected String packageName;

    ActionRenderer(Project project, File destiny, String packageName, String boxName, String type) {
        this.project = project;
        this.destiny = destiny;
        this.packageName = packageName;
        this.boxName = boxName;
        this.type = type;
    }

    boolean alreadyRendered(File destiny, String action) {
        return Commons.javaFile(this.destinyPackage(destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)action)) + "Action").exists();
    }

    File destinyPackage(File destiny) {
        return new File(destiny, "actions");
    }

    protected void execute(String name, Response response, List<? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        if (!this.alreadyRendered(this.destiny, name)) {
            this.createNewClass(name, response, parameters, exceptions, schemas);
        } else {
            File destiny = Commons.javaFile(this.destinyPackage(this.destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + "Action");
            new ActionUpdater(this.project, destiny, this.packageName, parameters, exceptions, response).update();
        }
    }

    private void createNewClass(String name, Response response, List<? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        FrameBuilder builder = new FrameBuilder(new String[]{"action", this.type}).add("name", (Object)name).add("package", (Object)this.packageName).add("box", (Object)this.boxName).add("returnType", (Object)Commons.returnType(response, this.packageName));
        this.setupParameters(parameters, builder);
        if (!exceptions.isEmpty()) {
            builder.add("throws", exceptions.stream().map(e -> e.code().name()).toArray(String[]::new));
        }
        if (!schemas.isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName).toFrame());
        }
        Commons.writeFrame(this.destinyPackage(this.destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + "Action", this.template().render((Object)builder.toFrame()));
    }

    private void setupParameters(List<? extends Parameter> parameters, FrameBuilder builder) {
        for (Parameter parameter : parameters) {
            FrameBuilder parameterBuilder = new FrameBuilder(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()});
            if (parameter.isList()) {
                parameterBuilder.add("list");
            }
            builder.add("parameter", (Object)parameterBuilder.add("name", Formatters.snakeCaseToCamelCase().format((Object)parameter.name$())).add("type", (Object)this.formatType(parameter.asType())).toFrame());
        }
    }

    private String formatType(TypeData typeData) {
        return (typeData.i$(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    protected String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    protected Template template() {
        return Formatters.customize(new ActionTemplate());
    }
}

