/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.rest;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RESTAccessorRenderer {
    private final RESTService service;
    private File destination;
    private String packageName;

    public RESTAccessorRenderer(RESTService restService, File destination, String packageName) {
        this.service = restService;
        this.destination = destination;
        this.packageName = packageName;
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName, new HashMap<String, String>()).execute();
        this.processService(this.service);
    }

    private void processService(RESTService service) {
        FrameBuilder frame = new FrameBuilder(new String[]{"accessor"});
        frame.add("name", (Object)service.name$());
        frame.add("package", (Object)this.packageName);
        this.setupAuthentication(service, frame);
        if (!service.graph().schemaList().isEmpty()) {
            frame.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
        }
        ArrayList resourceFrames = new ArrayList();
        service.core$().findNode(RESTService.Resource.class).stream().map(resource -> this.framesOf(service, (RESTService.Resource)((Object)resource))).forEach(resourceFrames::addAll);
        frame.add("resource", (Object)resourceFrames.toArray(new Frame[0]));
        frame.add("notification", service.notificationList().stream().map(notification -> this.frameOf(service, (RESTService.Notification)((Object)notification))).toArray(Frame[]::new));
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Accessor", this.template().render((Object)frame));
    }

    private void setupAuthentication(RESTService restService, FrameBuilder builder) {
        if (restService.authenticated() != null) {
            builder.add("auth", (Object)"");
        }
        if (restService.authenticatedWithCertificate() != null) {
            builder.add("certificate", (Object)"");
        } else if (restService.authenticatedWithToken() != null) {
            builder.add("token", (Object)"");
        }
    }

    @NotNull
    private List<Frame> framesOf(RESTService restService, RESTService.Resource resource) {
        List<Frame> list = resource.operationList().stream().map(operation -> this.processOperation((RESTService.Resource.Operation)((Object)operation), restService.authenticated() != null, restService.authenticatedWithCertificate() != null)).collect(Collectors.toList());
        if (list == null) {
            RESTAccessorRenderer.$$$reportNull$$$0(0);
        }
        return list;
    }

    private Frame frameOf(RESTService restService, RESTService.Notification notification) {
        FrameBuilder notificationBuilder = new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path()).add("name", (Object)notification.name$());
        if (restService.authenticatedWithToken() != null) {
            notificationBuilder.add("secure", (Object)"");
        }
        if (Commons.queryParameters(notification) > 0L || Commons.bodyParameters(notification) > 0L) {
            notificationBuilder.add("parameters", (Object)"parameters");
        }
        notificationBuilder.add("parameter", (Object)this.notificationParameters(notification.parameterList()));
        return notificationBuilder.toFrame();
    }

    private Frame processOperation(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        return new FrameBuilder(new String[]{"resource"}).add("returnType", (Object)Commons.returnType(operation.response(), this.packageName)).add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName()).add("name", (Object)operation.core$().owner().name()).add("parameter", (Object)this.parameters(operation.parameterList())).add("invokeSentence", (Object)this.invokeSentence(operation, authenticated, cert)).add("exceptionResponses", (Object)this.exceptionResponses(operation)).toFrame();
    }

    private Frame[] parameters(List<RESTService.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<RESTService.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(RESTService.Resource.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private Frame parameter(RESTService.Notification.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private String parameterType(RESTService.Resource.Parameter parameter) {
        String value = (parameter.isObject() && parameter.asObject().isComponent() ? String.join((CharSequence)".", this.packageName, "schemas.") : "") + parameter.asType().type();
        return parameter.i$(ListData.class) ? "List<" + value + ">" : value;
    }

    private String parameterType(RESTService.Notification.Parameter parameter) {
        String value = (parameter.isObject() && parameter.asObject().isComponent() ? String.join((CharSequence)".", this.packageName, "schemas.") : "") + parameter.asType().type();
        return parameter.i$(ListData.class) ? "List<" + value + ">" : value;
    }

    private Frame invokeSentence(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        Response response = operation.response();
        FrameBuilder result = response.asType() == null ? this.voidInvokeSentence() : (response.isObject() ? this.objectInvokeSentence(response) : (response.isFile() ? this.fileInvokeSentence(response.asFile()) : (response.isDate() ? this.dateInvokeSentence(response.asDate()) : (response.isDateTime() ? this.dateTimeInvokeSentence(response.asDateTime()) : this.primitiveInvokeSentence(response.asType())))));
        if (response.isList()) {
            result.add("list");
        }
        return result.add("doInvoke", (Object)this.doInvoke(operation, authenticated, cert)).toFrame();
    }

    private Frame doInvoke(RESTService.Resource.Operation operation, boolean authenticated, boolean cert) {
        FrameBuilder builder = new FrameBuilder(new String[]{"doInvoke"}).add("relativePath", (Object)this.processPath(Commons.path((RESTService.Resource)operation.core$().ownerAs(RESTService.Resource.class)))).add("type", (Object)(operation.response().isFile() ? "getResource" : ((Object)((Object)operation)).getClass().getSimpleName().toLowerCase()));
        if (authenticated) {
            builder.add("auth");
        }
        if (cert) {
            builder.add("cert");
        }
        if (Commons.queryParameters(operation) > 0L || Commons.bodyParameters(operation) > 0L) {
            builder.add("parameters", (Object)"parameters");
        }
        if (Commons.fileParameters(operation) > 0) {
            builder.add("resource", operation.parameterList().stream().filter(p -> p.i$(FileData.class)).map(Layer::name$).toArray(String[]::new));
        }
        return builder.toFrame();
    }

    private String processPath(String path) {
        StringBuilder builder = new StringBuilder();
        for (String pathPortion : path.split("/")) {
            if (pathPortion.startsWith(":")) {
                builder.append(" + \"/\" + ").append(this.asMethodParameter(pathPortion.substring(1)));
                continue;
            }
            builder.append(" + \"/").append(pathPortion).append("\"");
        }
        return builder.toString().substring(3);
    }

    private String asMethodParameter(String parameter) {
        String toCamelCase = StringHelper.snakeCaseToCamelCase((String)parameter);
        return Character.toLowerCase(toCamelCase.charAt(0)) + toCamelCase.substring(1);
    }

    private FrameBuilder exceptionResponses(RESTService.Resource.Operation operation) {
        List<Exception> exceptions = operation.exceptionList();
        if (exceptions.isEmpty()) {
            return new FrameBuilder(new String[]{"exceptionResponses", "none"});
        }
        return new FrameBuilder(new String[]{"exceptionResponses"}).add("exceptionResponse", (Object)this.exceptionResponses(exceptions));
    }

    private Frame[] exceptionResponses(List<Exception> responses) {
        return (Frame[])responses.stream().map(this::exceptionResponse).toArray(Frame[]::new);
    }

    private FrameBuilder finallyException(RESTService.Resource.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"io"});
        if (operation.response() == null || operation.response().asType() == null) {
            return builder;
        }
        return builder.add("return", (Object)"");
    }

    private Frame exceptionResponse(Exception response) {
        return new FrameBuilder(new String[]{"exceptionResponse"}).add("code", (Object)response.code().value()).add("exceptionName", (Object)response.code().toString()).toFrame();
    }

    private FrameBuilder voidInvokeSentence() {
        return new FrameBuilder(new String[]{"invokeSentence", "void"});
    }

    private FrameBuilder objectInvokeSentence(Response response) {
        return new FrameBuilder(new String[]{"invokeSentence", "object"}).add("returnType", (Object)Commons.returnType(response, this.packageName));
    }

    private FrameBuilder fileInvokeSentence(FileData fileData) {
        return new FrameBuilder(new String[]{"invokeSentence", "file"});
    }

    private FrameBuilder dateInvokeSentence(DateData dateData) {
        return new FrameBuilder(new String[]{"invokeSentence", "date"});
    }

    private FrameBuilder dateTimeInvokeSentence(DateTimeData dateTimeData) {
        return new FrameBuilder(new String[]{"invokeSentence", "datetime"});
    }

    private FrameBuilder primitiveInvokeSentence(TypeData typeData) {
        return new FrameBuilder(new String[]{"invokeSentence", "primitive", typeData.type()}).add("returnType", (Object)typeData.type());
    }

    private Template template() {
        return Formatters.customize(new RESTAccessorTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/accessor/rest/RESTAccessorRenderer", "framesOf"));
    }
}

