/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import io.intino.konos.builder.actions.Action;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class KonosAction
extends Action {
    public KonosAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Override
    public void update(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean enabled = module != null && this.legioFile(module).exists();
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        String version = file.getParentFile().getName();
        Configuration configuration = TaraUtil.configurationOf((Module)module);
        if (configuration == null) {
            return;
        }
        String interfaceVersion = configuration.boxVersion();
        e.getPresentation().setVisible(enabled & version.equals(interfaceVersion));
        e.getPresentation().setEnabled(enabled & version.equals(interfaceVersion));
    }

    @NotNull
    private File legioFile(Module module) {
        File moduleRoot = new File(module.getModuleFilePath()).getParentFile();
        return new File(moduleRoot, "configuration.legio");
    }
}

