/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.accessible;

import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AccessibleDisplay
extends Layer
implements Terminal {
    protected List<String> parameters = new ArrayList<String>();
    protected Display _display;

    public AccessibleDisplay(Node node) {
        super(node);
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public String parameters(int index) {
        return this.parameters.get(index);
    }

    public List<String> parameters(Predicate<String> predicate) {
        return this.parameters().stream().filter(predicate).collect(Collectors.toList());
    }

    public String label() {
        return this._display.label();
    }

    public List<Display> displays() {
        return this._display.displays();
    }

    public Display displays(int index) {
        return this._display.displays().get(index);
    }

    public String parentDisplay() {
        return this._display.parentDisplay();
    }

    public AccessibleDisplay label(String value) {
        this._display.label(value);
        return this;
    }

    public AccessibleDisplay parentDisplay(String value) {
        this._display.parentDisplay(value);
        return this;
    }

    public List<Display.Request> requestList() {
        return this._display.requestList();
    }

    public Display.Request requestList(int index) {
        return this._display.requestList().get(index);
    }

    public List<Display.Notification> notificationList() {
        return this._display.notificationList();
    }

    public Display.Notification notificationList(int index) {
        return this._display.notificationList().get(index);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("parameters", this.parameters);
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("parameters")) {
            this.parameters = StringLoader.load(values, (Layer)this);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("parameters")) {
            this.parameters = new ArrayList(values);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Display) {
            this._display = (Display)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void request(Predicate<Display.Request> filter) {
            new ArrayList<Display.Request>(AccessibleDisplay.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Display.Notification> filter) {
            new ArrayList<Display.Notification>(AccessibleDisplay.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Display.Request request() {
            Display.Request newElement = (Display.Request)AccessibleDisplay.this.core$().graph().concept(Display.Request.class).createNode(this.name, AccessibleDisplay.this.core$()).as(Display.Request.class);
            return newElement;
        }

        public Display.Notification notification() {
            Display.Notification newElement = (Display.Notification)AccessibleDisplay.this.core$().graph().concept(Display.Notification.class).createNode(this.name, AccessibleDisplay.this.core$()).as(Display.Notification.class);
            return newElement;
        }
    }
}

