/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.resource;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class ResourceTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"accessibledisplay", "resource"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".resources;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyAction;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.Unauthorized;\nimport io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;\nimport io.intino.alexandria.ui.displays.Soul;\nimport io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;\nimport io.intino.alexandria.ui.services.push.UIClient;\nimport io.intino.alexandria.ui.services.push.UISession;\n\nimport java.util.function.Function;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyResource extends io.intino.alexandria.ui.spark.resources.ProxyResource {\n\tprivate final ")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyResource(")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box, io.intino.alexandria.ui.spark.UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tfillBrowser(manager, session());\n\t\tfillDeviceParameter();\n\t\ttry {\n\t\t\tif (!isLogged(accessToken()))\n\t\t\t\tthrow new Unauthorized(\"user is not logged\");\n\n\t\t\tauthenticate(session(), accessToken());\n\t\t\trender();\n\t\t} catch (CouldNotObtainInfo couldNotObtainInfo) {\n\t\t\tthrow new Unauthorized(\"user is not logged\");\n\t\t} catch (Throwable error) {\n\t\t\tthrow new Unauthorized(\"could not render component\");\n\t\t}\n\t}\n\n\tprivate void render() {\n\t\tUIClient client = client();\n\n\t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyAction action = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyAction();\n\t\taction.session = session();\n\t\taction.session.browser().requestUrl(manager.requestUrl());\n\t\taction.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("ProxyResource.this.authenticate(baseUrl);\n\t\t\t}\n\t\t});\n\t\taction.session.whenLogout(b -> logout());\n\t\taction.box = box;\n\t\taction.clientId = client.id();\n\t\taction.googleApiKey = \"\";\n\t\taction.device = parameterValue(\"device\");\n\t\t")}).output(new Rule.Output[]{this.mark("parameter", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\t\tSoul soul = soul();\n\t\tif (soul != null) {\n\t\t\taction.soul = soul;\n\t\t\taction.execute();\n\t\t\treturn;\n\t\t}\n\n\t\tsoul = new Soul(action.session) {\n\t\t\t@Override\n\t\t\tpublic void personify() {\n\t\t\t\tSoul soul = this;\n\t\t\t\taddRegisterDisplayListener(display -> {\n\t\t\t\t\tdisplay.inject(notifier(action.session, client, display));\n\t\t\t\t\tdisplay.inject(action.session);\n\t\t\t\t\tdisplay.inject(soul);\n\t\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t\tclient.soul(soul);\n\t\taction.soul = soul;\n\t\taction.execute();\n\t\tbox.registerSoul(client.id(), soul);\n\n\t\tmanager.write(\"OK\");\n\t}\n}")}), this.rule().condition(this.type("resource"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".resources;\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Resource extends io.intino.alexandria.ui.spark.resources.")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("editor", new String[0])})}).output(new Rule.Output[]{this.literal("Resource {\n\tprivate final ")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Resource(")}).output(new Rule.Output[]{this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box, io.intino.alexandria.ui.spark.UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("confidential", new String[0])}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("if (isLogged()) render();")}).output(new Rule.Output[]{this.literal("\n")}).output(new Rule.Output[]{this.literal("else authenticate();")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("render();")}))}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action action = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Action();\n\t\taction.session = manager.currentSession();\n\t\taction.session.browser().requestUrl(manager.requestUrl());\n\t\taction.session.whenLogin(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Resource.this::authenticate);\n\t\taction.session.whenLogout(b -> logout());\n\t\taction.box = box;\n\t\taction.clientId = clientId;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("action.googleApiKey = ")}).output(new Rule.Output[]{this.mark("googleApiKey", new String[]{"format"})}).output(new Rule.Output[]{this.literal(";")})}).output(new Rule.Output[]{this.literal("\n\t\taction.device = parameterValue(\"device\");\n\t\taction.token = parameterValue(\"token\");\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("editor", new String[]{"parameters"})})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.mark("parameter", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\tif (!client.id().equals(action.clientId))\n\t\t\t\treturn false;\n\n\t\t\tif (client.soul() != null)\n\t\t\t\treturn false;\n\n\t\t\tio.intino.alexandria.ui.displays.Soul soul = action.prepareSoul(client);\n\t\t\tsoul.onRedirect((location) -> manager.redirect(location));\n\t\t\tsoul.addRegisterDisplayListener(display -> {\n\t\t\t\tdisplay.inject(notifier(action.session, client, display));\n\t\t\t\tdisplay.inject(action.session);\n\t\t\t\tdisplay.inject(soul);\n\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t});\n\t\t\tclient.soul(soul);\n\n\t\t\tbox.registerSoul(clientId, soul);\n\n\t\t\treturn true;\n\t\t});\n\n\t\tmanager.pushService().onClose(clientId).execute(new Consumer<io.intino.alexandria.ui.services.push.UIClient>() {\n\t\t\t@Override\n\t\t\tpublic void accept(io.intino.alexandria.ui.services.push.UIClient client) {\n\t\t\t\tbox.soul(client.id()).ifPresent(s -> s.destroy());\n\t\t\t\tbox.unRegisterSoul(client.id());\n\t\t\t\tmanager.unRegister(client);\n\t\t\t}\n\t\t});\n\n\t\tmanager.write(action.execute());\n\t}\n\n}")}), this.rule().condition(this.trigger("parameters"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("action.document = loadDocument();\naction.permission = loadPermission();")}), this.rule().condition(this.type("parameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("action.")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = parameterValue(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\");")}), this.rule().condition(this.type("googleapikey"), new Rule.Condition[]{this.trigger("format")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("custom", new String[0]).multiple("")})}), this.rule().condition(this.trigger("custom"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal(".replace(\"{")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("}\", box.configuration().get(\"")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("\"))")})});
    }
}

