/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.view;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIPrototypeRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.view.AbstractViewTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewTemplate;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.View;
import io.intino.konos.model.graph.catalogcontainer.CatalogContainerView;
import io.intino.konos.model.graph.collectioncontainer.CollectionContainerView;
import io.intino.konos.model.graph.displaycontainer.DisplayContainerView;
import io.intino.konos.model.graph.gridcontainer.GridContainerView;
import io.intino.konos.model.graph.listcontainer.ListContainerView;
import io.intino.konos.model.graph.magazinecontainer.MagazineContainerView;
import io.intino.konos.model.graph.mapcontainer.MapContainerView;
import io.intino.konos.model.graph.panelcontainer.PanelContainerView;
import io.intino.konos.model.graph.setcontainer.SetContainerView;
import io.intino.tara.magritte.Node;
import java.io.File;
import java.util.List;

public class ViewRenderer
extends UIPrototypeRenderer {
    private final View view;
    private final Component owner;
    private final String box;
    private final String packageName;

    public ViewRenderer(View view, Component owner, String box, String packageName) {
        super(view.name$(), box, packageName);
        this.view = view;
        this.owner = owner;
        this.box = box;
        this.packageName = packageName;
    }

    @Override
    public FrameBuilder frameBuilder() {
        FrameBuilder builder = super.frameBuilder().add("view").add("owner", (Object)this.owner.name$()).add("ownerClass", (Object)((Object)((Object)this.owner)).getClass().getSimpleName()).add("label", (Object)this.view.label()).add("layout", (Object)this.view.layout().name()).add("width", (Object)this.view.width());
        if (this.view.hidden() == View.Hidden.HiddenEnabled) {
            builder.add("hidden", (Object)this.hidden(this.view, this.box));
            builder.add("hasMethods");
        }
        this.addViewProperties(builder);
        return builder;
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(new ViewTemplate());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(new AbstractViewTemplate());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return null;
    }

    private void addViewProperties(FrameBuilder builder) {
        builder.add("viewDisplayLoaders", (Object)new FrameBuilder(new String[]{"viewDisplayLoaders"}).add("package", (Object)this.packageName));
        this.addCollectionContainerProperties(this.view, builder);
        this.addDisplayContainerProperties(this.view, builder);
        this.addMoldContainerProperties(this.view, builder);
        this.addCatalogContainerProperties(this.view, builder);
        this.addPanelContainerProperties(this.view, builder);
        this.addSetContainerProperties(this.view, builder);
    }

    private void addCollectionContainerProperties(View view, FrameBuilder builder) {
        if (!view.isCollectionContainer()) {
            return;
        }
        CollectionContainerView collectionView = this.view.asCollectionContainer();
        builder.add("mold", (Object)collectionView.mold().name$());
        if (collectionView.noItemsMessage() != null) {
            builder.add("noItemsMessage", (Object)collectionView.noItemsMessage());
        }
        this.addListContainerProperties(collectionView, builder);
        this.addGridContainerProperties(collectionView, builder);
        this.addMapContainerProperties(collectionView, builder);
        this.addMagazineContainerProperties(collectionView, builder);
    }

    private void addListContainerProperties(CollectionContainerView view, FrameBuilder builder) {
        if (!view.i$(ListContainerView.class)) {
            return;
        }
        builder.add("list");
    }

    private void addGridContainerProperties(CollectionContainerView view, FrameBuilder builder) {
        if (!view.i$(GridContainerView.class)) {
            return;
        }
        builder.add("grid");
    }

    private void addMapContainerProperties(CollectionContainerView view, FrameBuilder builder) {
        if (!view.i$(MapContainerView.class)) {
            return;
        }
        builder.add("map");
        MapContainerView mapView = (MapContainerView)view.a$(MapContainerView.class);
        if (mapView.center() != null) {
            builder.add("latitude", (Object)mapView.center().latitude()).add("longitude", (Object)mapView.center().longitude());
        }
        builder.add("zoom", (Object)new FrameBuilder(new String[]{"zoom"}).add("default", (Object)mapView.zoom().defaultZoom()).add("min", (Object)mapView.zoom().min()).add("max", (Object)mapView.zoom().max()));
    }

    private void addMagazineContainerProperties(CollectionContainerView view, FrameBuilder frame) {
        if (!view.i$(MagazineContainerView.class)) {
            return;
        }
        frame.add("magazine");
    }

    private void addDisplayContainerProperties(View view, FrameBuilder frame) {
        if (!view.isDisplayContainer()) {
            return;
        }
        frame.add("display");
        DisplayContainerView displayView = view.asDisplayContainer();
        frame.add("hideNavigator", (Object)displayView.hideNavigator());
        frame.add("display", (Object)displayView.display());
        if (this.owner.i$(Catalog.class)) {
            frame.add("catalogScope", (Object)new FrameBuilder(new String[]{"catalogScope"}).add("name", (Object)view.name$()).add("display", (Object)displayView.display()).add("box", (Object)this.box).add("owner", (Object)this.owner.name$()));
        }
    }

    private void addMoldContainerProperties(View view, FrameBuilder frame) {
        if (!view.isMoldContainer()) {
            return;
        }
        frame.add("mold");
        Mold mold = view.asMoldContainer().mold();
        frame.add("mold", (Object)mold.name$());
    }

    private void addCatalogContainerProperties(View view, FrameBuilder frame) {
        if (!view.isCatalogContainer()) {
            return;
        }
        frame.add("catalog");
        CatalogContainerView catalogContainerView = view.asCatalogContainer();
        frame.add("catalog", (Object)catalogContainerView.catalog().name$());
        frame.add("catalogDisplayLoader", (Object)new FrameBuilder(new String[]{"catalogDisplayLoader"}).add("package", (Object)this.packageName));
        if (catalogContainerView.filtered()) {
            frame.add("filter", (Object)this.filterFrame(view, this.box));
        }
    }

    private void addPanelContainerProperties(View view, FrameBuilder frame) {
        if (!view.isPanelContainer()) {
            return;
        }
        frame.add("panel");
        PanelContainerView panelContainerView = view.asPanelContainer();
        frame.add("panel", (Object)panelContainerView.panel().name$());
    }

    private void addSetContainerProperties(View view, FrameBuilder frame) {
        if (!view.isSetContainer()) {
            return;
        }
        frame.add("set");
        SetContainerView setView = view.asSetContainer();
        frame.add("viewContainerSetItems", (Object)new FrameBuilder(new String[]{"viewContainerSetItems"}).add("item", (Object)this.frameOf(setView.abstractItemList())));
    }

    private Frame[] frameOf(List<SetContainerView.AbstractItem> items) {
        return (Frame[])items.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(SetContainerView.AbstractItem item) {
        if (item.i$(SetContainerView.Group.class)) {
            return this.frameOf((SetContainerView.Group)item.a$(SetContainerView.Group.class));
        }
        if (item.i$(SetContainerView.Items.class)) {
            return this.frameOf((SetContainerView.Items)item.a$(SetContainerView.Items.class));
        }
        return this.frameOf((SetContainerView.Item)item.a$(SetContainerView.Item.class));
    }

    private Frame frameOf(SetContainerView.Group group) {
        FrameBuilder builder = this.baseFrameBuilder(group).add("group").add("label", (Object)group.label()).add("mode", (Object)group.mode());
        if (!group.itemList().isEmpty()) {
            builder.add("item", group.itemList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        if (!group.itemsList().isEmpty()) {
            builder.add("item", group.itemsList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        return builder.toFrame();
    }

    private Frame frameOf(SetContainerView.Item item) {
        FrameBuilder builder = this.baseFrameBuilder(item).add("item");
        View view = item.view();
        builder.add("label", (Object)item.label());
        builder.add("view", (Object)new ViewRenderer(view, this.owner, this.box, this.packageName).frameBuilder().toFrame());
        return builder.toFrame();
    }

    private Frame frameOf(SetContainerView.Items items) {
        FrameBuilder builder = this.baseFrameBuilder(items).add("items").add("layout", (Object)this.owner.name$()).add("path", (Object)this.pathOf(items.core$())).add("modelClass", (Object)items.itemClass());
        View view = items.view();
        builder.add("view", (Object)new ViewRenderer(view, this.owner, this.box, this.packageName).frameBuilder().toFrame());
        return builder.toFrame();
    }

    private FrameBuilder baseFrameBuilder(SetContainerView.AbstractItem item) {
        FrameBuilder builder = new FrameBuilder(new String[]{"set", ((Object)((Object)item)).getClass().getSimpleName().toLowerCase()}).add("box", (Object)this.box).add("name", (Object)item.name$());
        if (item.hidden() == SetContainerView.AbstractItem.Hidden.HiddenEnabled) {
            builder.add("hidden", (Object)new FrameBuilder().add("box", (Object)this.box).add("layout", (Object)this.owner.name$()).add("path", (Object)this.pathOf(item.core$())).toFrame());
        }
        return builder;
    }

    private FrameBuilder filterFrame(View view, String box) {
        String itemClass = view.asCatalogContainer().catalog().itemClass();
        return new FrameBuilder(new String[]{"filter"}).add("owner", (Object)this.owner.name$()).add("view", (Object)view.name$()).add("box", (Object)box).add("itemClass", (Object)itemClass);
    }

    private FrameBuilder hidden(View view, String box) {
        return new FrameBuilder(new String[]{"hidden"}).add("owner", (Object)this.owner.name$()).add("view", (Object)view.name$()).add("box", (Object)box);
    }

    private String pathOf(Node node) {
        StringBuilder qn = new StringBuilder();
        Node parent = node;
        while (!parent.equals(this.view.core$())) {
            qn.insert(0, StringFormatters.firstUpperCase().format((Object)parent.name()).toString() + (qn.length() == 0 ? "" : "."));
            parent = parent.owner();
        }
        qn.insert(0, StringFormatters.firstUpperCase().format((Object)this.view.core$().name()).toString() + (qn.length() == 0 ? "" : "."));
        return qn.toString();
    }
}

