/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.mold;

import com.intellij.openapi.project.Project;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.mold.AbstractMoldTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.mold.MoldTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.mold.MoldUpdater;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Mold;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoldRenderer
extends DisplayRenderer {
    private final Project project;
    private final Mold mold;

    public MoldRenderer(Project project, Mold mold, String packageName, String boxName) {
        super(mold, boxName, packageName);
        this.project = project;
        this.mold = mold;
    }

    @Override
    public FrameBuilder frameBuilder() {
        FrameBuilder builder = super.frameBuilder();
        builder.add("moldClass", (Object)this.moldClass());
        for (Mold.Block block : this.mold.blockList()) {
            builder.add("block", (Object)this.frameOf(block));
        }
        return builder;
    }

    public Frame frameOf(Mold.Block.Stamp stamp) {
        FrameBuilder builder = this.baseFrame(stamp).add("stamp").add("type", (Object)((Object)((Object)stamp)).getClass().getSimpleName()).add("common", (Object)this.common(stamp));
        if (stamp.i$(Mold.Block.Picture.class)) {
            this.frameOf(builder, (Mold.Block.Picture)stamp.a$(Mold.Block.Picture.class));
        } else if (stamp.i$(Mold.Block.Rating.class)) {
            this.frameOf(builder, (Mold.Block.Rating)stamp.a$(Mold.Block.Rating.class));
        } else if (stamp.i$(Mold.Block.Breadcrumbs.class)) {
            this.frameOf(builder, (Mold.Block.Breadcrumbs)stamp.a$(Mold.Block.Breadcrumbs.class));
        } else if (stamp.i$(Mold.Block.Location.class)) {
            this.frameOf(builder, (Mold.Block.Location)stamp.a$(Mold.Block.Location.class));
        } else if (stamp.i$(Mold.Block.Operation.class)) {
            this.frameOf(builder, (Mold.Block.Operation)stamp.a$(Mold.Block.Operation.class));
        } else if (stamp.i$(Mold.Block.CatalogLink.class)) {
            this.frameOf(builder, (Mold.Block.CatalogLink)stamp.a$(Mold.Block.CatalogLink.class));
        } else if (stamp.i$(Mold.Block.EmbeddedDisplay.class)) {
            this.frameOf(builder, (Mold.Block.EmbeddedDisplay)stamp.a$(Mold.Block.EmbeddedDisplay.class));
        } else if (stamp.i$(Mold.Block.EmbeddedDialog.class)) {
            this.frameOf(builder, (Mold.Block.EmbeddedDialog)stamp.a$(Mold.Block.EmbeddedDialog.class));
        } else if (stamp.i$(Mold.Block.EmbeddedCatalog.class)) {
            this.frameOf(builder, (Mold.Block.EmbeddedCatalog)stamp.a$(Mold.Block.EmbeddedCatalog.class));
        } else if (stamp.i$(Mold.Block.Icon.class)) {
            this.frameOf(builder, (Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class));
        } else if (stamp.i$(Mold.Block.ItemLinks.class)) {
            this.frameOf(builder, (Mold.Block.ItemLinks)stamp.a$(Mold.Block.ItemLinks.class));
        } else if (stamp.i$(Mold.Block.CardWallet.class)) {
            this.frameOf(builder, (Mold.Block.CardWallet)stamp.a$(Mold.Block.CardWallet.class));
        } else if (stamp.i$(Mold.Block.Timeline.class)) {
            this.frameOf(builder, (Mold.Block.Timeline)stamp.a$(Mold.Block.Timeline.class));
        } else if (stamp.i$(Mold.Block.Pie.class)) {
            this.frameOf(builder, (Mold.Block.Pie)stamp.a$(Mold.Block.Pie.class));
        } else if (stamp.i$(Mold.Block.Histogram.class)) {
            this.frameOf(builder, (Mold.Block.Histogram)stamp.a$(Mold.Block.Histogram.class));
        } else if (stamp.i$(Mold.Block.Map.class)) {
            this.frameOf(builder, (Mold.Block.Map)stamp.a$(Mold.Block.Map.class));
        }
        return builder.toFrame();
    }

    private Frame frameOf(Mold.Block block) {
        FrameBuilder builder = new FrameBuilder(new String[]{"block"}).add("name", Formatters.validMoldName().format((Object)block.name$())).add("expanded", (Object)block.mode().equals((Object)Mold.Block.Mode.Expanded)).add("layout", block.layout().stream().map(Enum::name).toArray(String[]::new)).add("hiddenIfMobile", (Object)block.hiddenIfMobile());
        if (block.hidden().equals((Object)Mold.Block.Hidden.HiddenEnabled)) {
            builder.add("hidden", (Object)this.baseFrame(block));
        }
        if (block.hasCustomClass()) {
            builder.add("blockClassName", (Object)this.baseFrame(block));
        }
        if (!block.style().isEmpty()) {
            builder.add("blockStyle", (Object)block.style());
        }
        if (block.height() >= 0) {
            builder.add("height", (Object)block.height());
        }
        if (block.width() >= 0) {
            builder.add("width", (Object)block.width());
        }
        for (Mold.Block.Stamp stamp : block.stampList()) {
            builder.add("stamp", (Object)this.frameOf(stamp));
        }
        for (Mold.Block inner : block.blockList()) {
            builder.add("block", (Object)this.frameOf(inner));
        }
        return builder.toFrame();
    }

    @NotNull
    private Frame common(Mold.Block.Stamp stamp) {
        FrameBuilder builder = this.baseFrame(stamp).add("common");
        if (!stamp.defaultStyle().isEmpty()) {
            builder.add("defaultStyle", (Object)stamp.defaultStyle());
        }
        if (stamp.hasCustomStyle()) {
            builder.add("style", (Object)this.baseFrame(stamp));
        }
        if (stamp.hasCustomClass()) {
            builder.add("className", (Object)this.baseFrame(stamp));
        }
        if (stamp.hasCustomLabel()) {
            builder.add("labelLoader", (Object)this.baseFrame(stamp));
        }
        if (stamp.hasCustomColor()) {
            builder.add("color", (Object)this.baseFrame(stamp));
        }
        if (stamp.editable()) {
            builder.add("editable", (Object)this.baseFrame(stamp));
        }
        if (stamp.height() >= 0) {
            builder.add("height", (Object)stamp.height());
        }
        if (!stamp.label().isEmpty()) {
            builder.add("label", (Object)stamp.label());
        }
        if (!stamp.suffix().isEmpty()) {
            builder.add("suffix", (Object)stamp.suffix());
        }
        this.addValueMethod(stamp, builder);
        Frame frame = builder.toFrame();
        if (frame == null) {
            MoldRenderer.$$$reportNull$$$0(0);
        }
        return frame;
    }

    private void addValueMethod(Mold.Block.Stamp stamp, FrameBuilder builder) {
        if (stamp.i$(Mold.Block.EmbeddedDisplay.class) || stamp.i$(Mold.Block.EmbeddedCatalog.class) || stamp.i$(Mold.Block.Operation.class) || stamp.i$(Mold.Block.Page.class)) {
            return;
        }
        builder.add("valueMethod", (Object)this.baseFrame(stamp).add("valueMethod").add("valueType", (Object)(stamp.i$(Mold.Block.Icon.class) && ((Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class)).source().equals((Object)Mold.Block.Icon.Source.Resource) ? Mold.Block.Icon.Source.Resource.name().toLowerCase() : ((Object)((Object)stamp)).getClass().getSimpleName())));
    }

    private void frameOf(FrameBuilder frame, Mold.Block.Picture stamp) {
        if (stamp.defaultPicture() != null) {
            frame.add("defaultPicture", (Object)stamp.defaultPicture());
        }
        if (stamp.avatar()) {
            frame.add("avatarProperties", (Object)this.baseFrame(stamp));
        }
    }

    private void frameOf(FrameBuilder frame, Mold.Block.Rating stamp) {
        frame.add("ratingIcon", (Object)stamp.polymerIcon());
        frame.add("ratingMax", (Object)stamp.max());
    }

    private void frameOf(FrameBuilder frame, Mold.Block.EmbeddedCatalog stamp) {
        if (stamp.maxItems() > 0) {
            frame.add("embeddedCatalogMaxItems", (Object)stamp.maxItems());
        }
        if (stamp.filtered()) {
            frame.add("catalogFilter", (Object)this.baseFrame(stamp));
        }
        frame.add("catalog", (Object)stamp.catalog().name$());
        frame.add("view", stamp.views().stream().map(Layer::name$).toArray(String[]::new));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.OpenCatalogOperation stamp) {
        if (stamp.filtered()) {
            builder.add("catalogFilter", (Object)this.baseFrame(stamp));
        }
        if (stamp.selection() != Mold.Block.OpenCatalogOperation.Selection.None) {
            builder.add("openCatalogOperationExecution", (Object)this.baseFrame(stamp));
        }
        builder.add("catalog", (Object)stamp.catalog().name$());
        builder.add("view", stamp.views().stream().map(Layer::name$).toArray(String[]::new));
        builder.add("width", (Object)stamp.width());
        builder.add("position", (Object)stamp.position().toString());
        builder.add("selection", (Object)stamp.selection().toString());
    }

    private void frameOf(FrameBuilder builder, Mold.Block.EmbeddedDisplay stamp) {
        builder.add("displayBuilder", (Object)this.baseFrame(stamp).add("displayBuilder"));
        if (stamp.display() != null) {
            builder.add("displayType", (Object)stamp.display().name$());
        }
    }

    private void frameOf(FrameBuilder builder, Mold.Block.EmbeddedDialog stamp) {
        builder.add("embeddedDialogBuilder", (Object)this.baseFrame(stamp).add("dialog", (Object)stamp.dialog().name$()).add("package", (Object)this.packageName));
        builder.add("dialogType", (Object)stamp.dialog().name$());
    }

    private void frameOf(FrameBuilder builder, Mold.Block.CatalogLink stamp) {
        builder.add("catalog", (Object)stamp.catalog().name$());
        if (stamp.filtered()) {
            builder.add("filter", (Object)this.baseFrame(stamp).add("filter"));
        }
        if (stamp.openItem()) {
            builder.add("itemLoader", (Object)this.baseFrame(stamp).add("itemLoader"));
        }
    }

    private void frameOf(FrameBuilder builder, Mold.Block.ItemLinks stamp) {
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.CardWallet stamp) {
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Timeline stamp) {
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Pie stamp) {
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Histogram stamp) {
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Icon stamp) {
        builder.add(stamp.source().name() + "Icon");
        builder.add("title", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Breadcrumbs stamp) {
        if (stamp.root() != null) {
            builder.add("root", (Object)stamp.root().name$());
        }
        this.frameOf(builder, stamp.treeItemList());
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Location stamp) {
        builder.add("icon", (Object)this.baseFrame(stamp));
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Map stamp) {
        builder.add("zoom", (Object)stamp.zoom());
        builder.add("latitude", (Object)stamp.latitude());
        builder.add("longitude", (Object)stamp.longitude());
    }

    private void frameOf(FrameBuilder builder, Mold.Block.Operation operation) {
        builder.add(((Object)((Object)operation)).getClass().getSimpleName()).add("mode", (Object)operation.mode().toString());
        if (operation.alexandriaIcon() != null) {
            builder.add("alexandriaIcon", (Object)operation.alexandriaIcon());
        }
        if (operation.i$(Mold.Block.OpenDialogOperation.class)) {
            Mold.Block.OpenDialogOperation openDialogOperation = (Mold.Block.OpenDialogOperation)operation.a$(Mold.Block.OpenDialogOperation.class);
            Dialog dialog = openDialogOperation.dialog();
            if (dialog != null) {
                builder.add("width", (Object)openDialogOperation.width()).add("dialogType", (Object)dialog.name$()).add("dialogBuilder", (Object)this.frame(openDialogOperation));
            }
        } else if (operation.i$(Mold.Block.OpenExternalDialogOperation.class)) {
            Mold.Block.OpenExternalDialogOperation openExternalDialogOperation = (Mold.Block.OpenExternalDialogOperation)operation.a$(Mold.Block.OpenExternalDialogOperation.class);
            builder.add("width", (Object)openExternalDialogOperation.width()).add("dialogPathBuilder", (Object)this.baseFrame(openExternalDialogOperation)).add("dialogTitleBuilder", (Object)this.baseFrame(openExternalDialogOperation));
        } else if (operation.i$(Mold.Block.OpenCatalogOperation.class)) {
            this.frameOf(builder, (Mold.Block.OpenCatalogOperation)operation.a$(Mold.Block.OpenCatalogOperation.class));
        } else if (operation.i$(Mold.Block.DownloadOperation.class)) {
            builder.add("options", (Object)((Mold.Block.DownloadOperation)operation.a$(Mold.Block.DownloadOperation.class)).options().toArray(new String[0]));
            builder.add("downloadExecution", (Object)this.baseFrame(operation));
        } else if (operation.i$(Mold.Block.ExportOperation.class)) {
            Mold.Block.ExportOperation export = (Mold.Block.ExportOperation)operation.a$(Mold.Block.ExportOperation.class);
            if (!export.options().isEmpty()) {
                builder.add("options", (Object)export.options().toArray(new String[0]));
            }
            builder.add("exportExecution", (Object)this.baseFrame(operation));
            if (export.from() != null) {
                builder.add("from", (Object)export.from().toEpochMilli());
            }
            if (export.to() != null) {
                builder.add("to", (Object)export.to().toEpochMilli());
            }
        } else if (operation.i$(Mold.Block.PreviewOperation.class)) {
            builder.add("previewExecution", (Object)this.baseFrame(operation));
        } else if (operation.i$(Mold.Block.TaskOperation.class)) {
            Mold.Block.TaskOperation taskOperation = (Mold.Block.TaskOperation)operation.a$(Mold.Block.TaskOperation.class);
            builder.add("taskExecution", (Object)this.baseFrame(operation)).add("mold", (Object)this.mold.name$());
            if (taskOperation.confirmText() != null) {
                builder.add("confirmText", (Object)taskOperation.confirmText());
            }
        }
    }

    private void frameOf(FrameBuilder builder, List<Mold.Block.Breadcrumbs.TreeItem> treeItems) {
        for (Mold.Block.Breadcrumbs.TreeItem item : treeItems) {
            FrameBuilder sub = new FrameBuilder(new String[]{"treeItem"}).add("label", (Object)item.label());
            if (!item.treeItemList().isEmpty()) {
                this.frameOf(sub, item.treeItemList());
            }
            builder.add("treeItem", (Object)sub.toFrame());
        }
    }

    private Frame frame(Mold.Block.OpenDialogOperation operation) {
        return new FrameBuilder(new String[]{((Object)((Object)operation)).getClass().getSimpleName()}).add("dialog", (Object)operation.dialog().name$()).add("package", (Object)this.packageName).toFrame();
    }

    private FrameBuilder baseFrame(Mold.Block.Stamp stamp) {
        return new FrameBuilder(new String[]{((Object)((Object)stamp)).getClass().getSimpleName()}).add("mold", (Object)this.mold.name$()).add("name", (Object)stamp.name$()).add("moldClass", (Object)this.moldClass()).add("box", (Object)this.box);
    }

    private FrameBuilder baseFrame(Mold.Block block) {
        FrameBuilder frame = new FrameBuilder(new String[]{((Object)((Object)block)).getClass().getSimpleName()}).add("mold", (Object)this.mold.name$()).add("name", (Object)block.name$()).add("moldClass", (Object)this.moldClass()).add("box", (Object)this.box);
        if (block.hidden() == Mold.Block.Hidden.HiddenEnabled) {
            frame.add("HiddenEnabled", (Object)"HiddenEnabled");
        }
        return frame;
    }

    private String moldClass() {
        return this.mold.modelClass() == null || this.mold.modelClass().isEmpty() ? "java.lang.Object" : this.mold.modelClass();
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(new MoldTemplate());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(new AbstractMoldTemplate());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return new MoldUpdater(sourceFile, (Mold)this.display().a$(Mold.class), this.project, this.packageName, this.box);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/ui/display/mold/MoldRenderer", "common"));
    }
}

