/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.desktop;

import com.intellij.openapi.project.Project;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelRenderer;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.desktop.DesktopPanel;
import io.intino.konos.model.graph.ui.UIService;

public class DesktopRenderer
extends PanelRenderer {
    public DesktopRenderer(Project project, DesktopPanel desktop, String packageName, String boxName) {
        super(project, (Panel)desktop.a$(Panel.class), packageName, boxName);
    }

    @Override
    public FrameBuilder frameBuilder() {
        UIService service;
        DesktopPanel desktop = ((Panel)this.display().a$(Panel.class)).asDesktop();
        FrameBuilder frame = super.frameBuilder();
        frame.add("desktop");
        frame.add("title", (Object)desktop.title());
        frame.add("subtitle", (Object)desktop.subTitle());
        frame.add("layout", (Object)desktop.layout().name());
        if (desktop.logoPath() != null && !desktop.logoPath().isEmpty()) {
            frame.add("logo", (Object)desktop.logoPath());
        }
        if (desktop.faviconPath() != null && !desktop.faviconPath().isEmpty()) {
            frame.add("favicon", (Object)desktop.faviconPath());
        }
        if ((service = this.findOwnerUIService()) != null && service.authentication() != null) {
            frame.add("authentication", (Object)new FrameBuilder(new String[]{this.isCustom(service.authentication().by()) ? "custom" : "standard"}).add("value", (Object)service.authentication().by()));
        }
        return frame;
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private UIService findOwnerUIService() {
        Display display = this.display();
        return display.graph().uIServiceList().stream().filter(s -> s.userHome() != null && ((Object)((Object)display)).equals((Object)KonosGraph.componentFor(s.userHome()))).findFirst().orElse(null);
    }
}

