/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.catalog;

import com.intellij.openapi.project.Project;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.AbstractCatalogTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewRenderer;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import java.io.File;

public class CatalogRenderer
extends DisplayRenderer {
    private final Project project;
    private final String itemClass;

    public CatalogRenderer(Project project, Catalog catalog, String packageName, String box) {
        super(catalog, box, packageName);
        this.project = project;
        this.itemClass = catalog.itemClass();
    }

    @Override
    public FrameBuilder frameBuilder() {
        Catalog catalog = (Catalog)this.display().a$(Catalog.class);
        FrameBuilder builder = super.frameBuilder().add("catalog").add("type", (Object)this.itemClass);
        if (catalog.i$(TemporalCatalog.class)) {
            TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
            builder.add("mode", (Object)temporalCatalog.type().name());
            builder.add("scale", (Object)temporalCatalog.scales().stream().map(Enum::name).toArray());
            builder.add("range", (Object)new FrameBuilder().add("catalog", (Object)catalog.name$()).add("box", (Object)this.box).add("type", (Object)this.itemClass).toFrame());
            if (temporalCatalog.temporalFilter() != null) {
                builder.add("temporalFilter", (Object)this.frameOf(temporalCatalog, temporalCatalog.temporalFilter()));
            }
        }
        if (catalog.label() != null) {
            builder.add("label", (Object)catalog.label());
        }
        if (catalog.events() != null) {
            builder.add("event", (Object)this.frameOf(catalog.events().onClickItem()));
        }
        if (catalog.toolbar() != null) {
            builder.add("toolbar", (Object)this.frameOf(catalog.toolbar()));
        }
        if (catalog.hasCustomItemsArrivalMessage()) {
            builder.add("hasCustomItemsArrivalMessage", (Object)this.baseFrameBuilder());
        }
        this.views(catalog, builder);
        this.arrangements(catalog, builder);
        return builder;
    }

    private Frame frameOf(TemporalCatalog catalog, TemporalCatalog.TemporalFilter filter) {
        FrameBuilder builder = new FrameBuilder().add("temporalFilterLayout", (Object)filter.layout().toString());
        FrameBuilder enabledFrame = new FrameBuilder();
        if (filter.enabled() == TemporalCatalog.TemporalFilter.Enabled.Conditional) {
            enabledFrame.add("catalog", (Object)catalog.name$());
        }
        builder.add("temporalFilterEnabled", (Object)enabledFrame.add(filter.enabled().toString(), (Object)filter.enabled().toString()));
        FrameBuilder visibleFrame = new FrameBuilder();
        if (filter.visible() == TemporalCatalog.TemporalFilter.Visible.Conditional) {
            visibleFrame.add("catalog", (Object)catalog.name$());
        }
        builder.add("temporalFilterVisible", (Object)visibleFrame.add(filter.visible().toString(), (Object)filter.visible().toString()));
        return builder.toFrame();
    }

    private Frame frameOf(Catalog.Events.OnClickItem onClickItem) {
        Catalog.Events.OnClickItem.CatalogEvent catalogEvent = onClickItem.catalogEvent();
        Display display = this.display();
        if (catalogEvent.i$(Catalog.Events.OnClickItem.OpenPanel.class)) {
            return this.frameOf((Catalog.Events.OnClickItem.OpenPanel)catalogEvent.a$(Catalog.Events.OnClickItem.OpenPanel.class), (Catalog)display.a$(Catalog.class), this.box, this.itemClass);
        }
        if (catalogEvent.i$(Catalog.Events.OnClickItem.OpenCatalog.class)) {
            return this.frameOf((Catalog.Events.OnClickItem.OpenCatalog)catalogEvent.a$(Catalog.Events.OnClickItem.OpenCatalog.class), (Catalog)display.a$(Catalog.class), this.box, this.itemClass);
        }
        return this.frameOf((Catalog.Events.OnClickItem.OpenDialog)catalogEvent.a$(Catalog.Events.OnClickItem.OpenDialog.class), display);
    }

    public Frame frameOf(Catalog.Events.OnClickItem.OpenDialog openDialog, Display catalog) {
        FrameBuilder builder = new FrameBuilder(new String[]{"event", ((Object)((Object)openDialog)).getClass().getSimpleName()}).add("box", (Object)this.box).add("package", (Object)this.packageName);
        if (openDialog.height() >= 0) {
            builder.add("height", (Object)openDialog.height());
        }
        if (openDialog.width() >= 0) {
            builder.add("width", (Object)openDialog.width());
        }
        builder.add("dialog", (Object)openDialog.dialog().name$());
        builder.add("catalog", (Object)catalog.name$());
        return builder.toFrame();
    }

    public Frame frameOf(Catalog.Events.OnClickItem.OpenPanel openPanel, Catalog catalog, String box, String modelClass) {
        FrameBuilder builder = new FrameBuilder(new String[]{"event", ((Object)((Object)openPanel)).getClass().getSimpleName()});
        builder.add("panel", (Object)openPanel.panel().name$());
        if (openPanel.hasBreadcrumbs()) {
            builder.add("breadcrumbs", (Object)new FrameBuilder(new String[]{"breadCrumbs"}).add("catalog", (Object)catalog.name$()).add("box", (Object)box).add("type", (Object)modelClass));
        }
        return builder.toFrame();
    }

    public Frame frameOf(Catalog.Events.OnClickItem.OpenCatalog openCatalog, Catalog catalog, String box, String modelClass) {
        FrameBuilder builder = new FrameBuilder(new String[]{"event", ((Object)((Object)openCatalog)).getClass().getSimpleName()});
        builder.add("catalog", (Object)openCatalog.catalog().name$());
        if (openCatalog.openItem()) {
            builder.add("openCatalogLoader", (Object)new FrameBuilder(new String[]{"openCatalogLoader"}).add("catalog", (Object)catalog.name$()).add("box", (Object)box).add("type", (Object)modelClass));
        }
        if (openCatalog.filtered()) {
            builder.add("openCatalogFilter", (Object)new FrameBuilder(new String[]{"openCatalogFilter"}).add("catalog", (Object)catalog.name$()).add("box", (Object)box).add("type", (Object)modelClass));
        }
        return builder.toFrame();
    }

    private void views(Catalog catalog, FrameBuilder frameBuilder) {
        if (catalog.views().viewList().stream().anyMatch(View::isMagazineContainer)) {
            FrameBuilder hasMagazineBuilder = this.baseFrameBuilder().add("type", (Object)catalog.itemClass());
            if (catalog.i$(TemporalCatalog.class)) {
                TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
                hasMagazineBuilder.add("mode", (Object)temporalCatalog.type().name());
                hasMagazineBuilder.add("scale", (Object)temporalCatalog.scales().stream().map(Enum::name).toArray());
            }
            frameBuilder.add("hasMagazineView", (Object)hasMagazineBuilder.toFrame());
        }
        catalog.views().viewList().forEach(view -> {
            ViewRenderer builder = new ViewRenderer((View)((Object)view), this.display(), this.box, this.packageName);
            frameBuilder.add("view", (Object)new FrameBuilder(new String[]{"view"}).add("value", (Object)builder.frameBuilder()).toFrame());
        });
    }

    private Frame frameOf(Toolbar toolbar) {
        FrameBuilder builder = new FrameBuilder(new String[]{"toolbar"}).add("box", (Object)this.box).add("type", (Object)this.itemClass).add("canSearch", (Object)toolbar.canSearch());
        toolbar.operations().forEach(operation -> {
            OperationRenderer renderer = new OperationRenderer((AbstractToolbar.Operation)((Object)operation), this.display(), this.box, this.packageName);
            builder.add("operation", (Object)renderer.frameBuilder());
        });
        return builder.toFrame();
    }

    private void arrangements(Catalog catalog, FrameBuilder builder) {
        boolean existsGroupings;
        Catalog.Content content = catalog.content();
        boolean bl = existsGroupings = content != null && !content.groupingList().isEmpty();
        if (existsGroupings) {
            builder.add("hasGroupings", (Object)this.baseFrameBuilder().add("histogramsMode", (Object)content.histograms().toString()).add("position", (Object)content.groupingsPosition().toString()));
        }
        if (content == null) {
            return;
        }
        content.groupingList().forEach(grouping -> builder.add("arrangement", (Object)this.frameOf((Catalog.Content.Grouping)((Object)grouping), catalog, this.box, this.itemClass)));
        content.sortingList().forEach(sorting -> builder.add("arrangement", (Object)this.frameOf((Catalog.Content.Sorting)((Object)sorting), catalog, this.box, this.itemClass)));
    }

    private FrameBuilder baseFrameBuilder() {
        return new FrameBuilder().add("box", (Object)this.box).add("name", (Object)this.display().name$());
    }

    public Frame frameOf(Catalog.Content.Grouping grouping, Catalog catalog, String box, String modelClass) {
        return new FrameBuilder(new String[]{"arrangement", ((Object)((Object)grouping)).getClass().getSimpleName().toLowerCase()}).add("box", (Object)box).add("name", (Object)grouping.name$()).add("label", (Object)grouping.label()).add("catalog", (Object)catalog.name$()).add("type", (Object)modelClass).add("histogram", (Object)grouping.histogram()).toFrame();
    }

    public Frame frameOf(Catalog.Content.Sorting sorting, Catalog catalog, String box, String modelClass) {
        return new FrameBuilder(new String[]{"arrangement", ((Object)((Object)sorting)).getClass().getSimpleName().toLowerCase()}).add("box", (Object)box).add("name", (Object)sorting.name$()).add("label", (Object)sorting.label()).add("visible", (Object)sorting.visible()).add("catalog", (Object)catalog.name$()).add("type", (Object)modelClass).toFrame();
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(new CatalogTemplate());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(new AbstractCatalogTemplate());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return new CatalogUpdater(sourceFile, (Catalog)this.display().a$(Catalog.class), this.project, this.packageName, this.box);
    }
}

