/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.dialog;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.AbstractDialogRenderer;
import io.intino.konos.builder.codegeneration.services.ui.dialog.DialogTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.Map;

public class DialogRenderer
extends UIRenderer {
    private final File gen;
    private final File src;
    private final List<Dialog> dialogs;
    private final Map<String, String> classes;
    private KonosGraph graph;

    public DialogRenderer(KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        super(boxName, packageName);
        this.graph = graph;
        this.gen = gen;
        this.src = src;
        this.dialogs = graph.dialogList();
        this.classes = classes;
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        this.renderDialog(dialog);
        this.renderDialogDisplay();
    }

    private void renderDialog(Dialog dialog) {
        String newDialog = StringHelper.snakeCaseToCamelCase((String)dialog.name$());
        if (Commons.javaFile(new File(this.src, "dialogs"), newDialog).exists()) {
            return;
        }
        FrameBuilder builder = this.frameBuilder().add("dialog").add("name", (Object)dialog.name$());
        this.processToolbar(builder, dialog.toolbar());
        for (Dialog.Tab tab : dialog.tabList()) {
            this.processTab(builder, tab);
        }
        this.classes.put("Dialog#" + dialog.name$(), "dialogs." + newDialog);
        Commons.writeFrame(new File(this.src, "dialogs"), newDialog, this.template().render((Object)builder.toFrame()));
    }

    private void processToolbar(FrameBuilder builder, Dialog.Toolbar toolbar) {
        if (toolbar == null) {
            return;
        }
        for (Dialog.Toolbar.Operation operation : toolbar.operationList()) {
            this.processExecution(builder, operation);
        }
    }

    private void processExecution(FrameBuilder builder, Dialog.Toolbar.Operation operation) {
        builder.add("execution", (Object)new FrameBuilder().add("execution").add("box", (Object)this.box).add("name", (Object)operation.name$()));
    }

    private void processTab(FrameBuilder builder, Dialog.Tab tab) {
        for (Dialog.Tab.Input input : tab.inputList()) {
            this.processInput(builder, input);
        }
    }

    private void processInput(FrameBuilder builder, Dialog.Tab.Input input) {
        this.processValidator(builder, input);
        if (input.i$(Dialog.Tab.OptionBox.class)) {
            this.processSources(builder, (Dialog.Tab.OptionBox)input.a$(Dialog.Tab.OptionBox.class));
        } else if (input.i$(Dialog.Tab.Section.class)) {
            for (Dialog.Tab.Input i : ((Dialog.Tab.Section)input).inputList()) {
                this.processInput(builder, i);
            }
        }
    }

    private void processSources(FrameBuilder builder, Dialog.Tab.OptionBox optionBox) {
        if (optionBox.source() != null && !optionBox.source().isEmpty()) {
            builder.add("source", (Object)new FrameBuilder(new String[]{"source"}).add("box", (Object)this.box).add("name", (Object)optionBox.source()).add("field", (Object)((Object)((Object)optionBox)).getClass().getSimpleName()));
        }
    }

    private void processValidator(FrameBuilder builder, Dialog.Tab.Input input) {
        if (input.validator() != null && !input.validator().isEmpty()) {
            builder.add("validator", (Object)new FrameBuilder(new String[]{"validator"}).add("box", (Object)this.box).add("name", (Object)input.validator()).add("field", (Object)((Object)((Object)input)).getClass().getSimpleName()));
        }
    }

    private void renderDialogDisplay() {
        new AbstractDialogRenderer(this.graph, this.gen, this.packageName, this.box).execute();
    }

    private Template template() {
        return Formatters.customize(new DialogTemplate());
    }
}

