/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jmx;

import com.intellij.openapi.project.Project;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.JMXActionRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.List;
import java.util.Map;

public class JMXOperationsServiceRenderer {
    private final Project project;
    private final List<JMXService> services;
    private final File gen;
    private final String boxName;
    private final Map<String, String> classes;
    private File src;
    private String packageName;

    public JMXOperationsServiceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.jMXServiceList();
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(service -> {
            this.createInterface((JMXService)((Object)service));
            this.createImplementation((JMXService)((Object)service));
            this.createCorrespondingActions(service.operationList());
        });
    }

    private void createInterface(JMXService service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"jmx", "interface"}).add("name", (Object)service.name$()).add("package", (Object)this.packageName).add("box", (Object)this.boxName);
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
        }
        for (JMXService.Operation operation : service.operationList()) {
            builder.add("operation", (Object)this.frameOf(operation));
        }
        Commons.writeFrame(this.destinationPackage(), service.name$() + "MBean", this.template().render((Object)builder));
    }

    private void createImplementation(JMXService service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"jmx", "implementation"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("operation", service.operationList().stream().map(this::frameOf).toArray(Frame[]::new));
        Commons.writeFrame(this.destinationPackage(), service.name$(), this.template().render((Object)builder));
    }

    private void createCorrespondingActions(List<JMXService.Operation> operations) {
        for (JMXService.Operation operation : operations) {
            new JMXActionRenderer(this.project, operation, this.src, this.packageName, this.boxName, this.classes).execute();
        }
    }

    private Frame frameOf(JMXService.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"}).add("name", (Object)operation.name$()).add("action", (Object)operation.name$()).add("package", (Object)this.packageName).add("returnType", (Object)this.returnType(operation));
        builder.add("description", (Object)operation.description());
        this.setupParameters(operation.parameterList(), builder);
        return builder.toFrame();
    }

    private Frame returnType(JMXService.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"returnType"}).add("value", (Object)(operation.response() == null ? "void" : this.formatType(operation.response().asType())));
        if (operation.response() != null && operation.response().i$(ListData.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private String formatType(TypeData typeData) {
        return (typeData.i$(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, FrameBuilder builder) {
        for (Parameter parameter : parameters) {
            FrameBuilder parameterBuilder = new FrameBuilder(new String[]{"parameter"}).add("name", (Object)parameter.name$()).add("type", (Object)this.formatType(parameter.asType()));
            if (parameter.i$(ListData.class)) {
                parameterBuilder.add("list");
            }
            builder.add("parameter", (Object)parameterBuilder.toFrame());
        }
    }

    private Template template() {
        return Formatters.customize(new JMXServerTemplate());
    }

    private File destinationPackage() {
        return new File(this.gen, "jmx");
    }
}

