/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.exception;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.exception.ExceptionTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;

public class ExceptionRenderer {
    private static final String EXCEPTIONS = "exceptions";
    private final List<Exception> exceptions;
    private File gen;
    private String packageName;

    public ExceptionRenderer(KonosGraph graph, File gen, String packageName) {
        this.exceptions = graph.exceptionList();
        this.gen = gen;
        this.packageName = packageName;
    }

    public void execute() {
        this.exceptions.forEach(this::processException);
    }

    private void processException(Exception exception) {
        Commons.writeFrame(this.destinyPackage(this.gen), Commons.firstUpperCase(exception.name$()), this.template().render((Object)new FrameBuilder(new String[]{"exception"}).add("name", (Object)exception.name$()).add("code", (Object)exception.code()).add("package", (Object)this.packageName).toFrame()));
    }

    private File destinyPackage(File destiny) {
        return new File(destiny, EXCEPTIONS);
    }

    private Template template() {
        return new ExceptionTemplate();
    }
}

