/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.mounter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import java.io.File;
import java.util.List;
import java.util.Map;

public class MounterRenderer {
    private final List<Mounter> mounters;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public MounterRenderer(KonosGraph graph, File src, String packageName, String boxName, Map<String, String> classes) {
        this.mounters = graph.nessClient(0).mounterList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            FrameBuilder builder = new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("name", (Object)mounter.name());
            if (mounter.schema() != null) {
                builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName));
                builder.add("type", (Object)new FrameBuilder(new String[]{"schema"}).add("package", (Object)this.packageName).add("name", (Object)mounter.schema().name$()));
            } else {
                builder.add("type", (Object)"message");
            }
            File destination = new File(this.src, "datalake/mounters");
            String handlerName = mounter.name() + "Mounter";
            this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datalake.mounters." + handlerName);
            if (this.alreadyRendered(destination, handlerName)) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        }
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

