/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.feeder;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.feeder.AbstractFeederTemplate;
import io.intino.konos.builder.codegeneration.datalake.feeder.FeederTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Sensor;
import io.intino.konos.model.graph.documentedition.DocumentEditionSensor;
import io.intino.konos.model.graph.documentsignature.DocumentSignatureSensor;
import io.intino.konos.model.graph.formedition.FormEditionSensor;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.poll.PollSensor;
import io.intino.konos.model.graph.usersensor.UserSensorSensor;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FeederRenderer {
    private final List<Feeder> feeders;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;
    private final NessClient nessClient;
    private final File gen;
    private final String domain;

    public FeederRenderer(KonosGraph graph, File gen, File src, String packageName, String boxName, Map<String, String> classes) {
        this.nessClient = graph.nessClient(0);
        this.gen = gen;
        this.domain = this.nessClient.domain();
        this.feeders = this.nessClient.feederList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public static String name(Feeder feeder) {
        return FeederRenderer.isAnonymous(feeder) ? feeder.eventTypes().stream().map(s -> Commons.firstUpperCase(s.name$())).collect(Collectors.joining()) + "Feeder" : feeder.name$();
    }

    private static boolean isAnonymous(Feeder feeder) {
        return feeder.name$().matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    }

    public void execute() {
        for (Feeder feeder : this.feeders) {
            FrameBuilder builder = new FrameBuilder(new String[]{"feeder"}).add("box", (Object)this.boxName).add("package", (Object)this.packageName).add("name", (Object)FeederRenderer.name(feeder));
            for (Sensor sensor : feeder.sensorList()) {
                builder.add("sensor", (Object)this.frameOf(sensor, FeederRenderer.name(feeder)));
            }
            builder.add("eventType", feeder.eventTypes().stream().filter(Objects::nonNull).map(s -> this.composedType((Schema)((Object)s), feeder.subdomain())).toArray(String[]::new));
            builder.add("domain", (Object)this.fullDomain(feeder.subdomain()));
            String feederClassName = Commons.firstUpperCase(FeederRenderer.name(feeder));
            this.classes.put(((Object)((Object)feeder)).getClass().getSimpleName() + "#" + FeederRenderer.name(feeder), "datalake.feeders." + feederClassName);
            Commons.writeFrame(new File(this.gen, "datalake/feeders"), "Abstract" + feederClassName, Formatters.customize(new AbstractFeederTemplate()).render((Object)builder.toFrame()));
            if (this.alreadyRendered(new File(this.src, "datalake/feeders"), feederClassName)) continue;
            Commons.writeFrame(new File(this.src, "datalake/feeders"), feederClassName, Formatters.customize(new FeederTemplate()).render((Object)builder.toFrame()));
        }
    }

    private Frame frameOf(Sensor sensor, String feeder) {
        FrameBuilder builder = new FrameBuilder(new String[]{"sensor"}).add("name", (Object)sensor.name$()).add("feeder", (Object)feeder).add("type", (Object)(((Concept)sensor.core$().conceptList().get(0)).id().replaceAll("#.*", "") + "Sensor")).add("parent", (Object)this.parent(sensor));
        if (sensor.isUserSensor()) {
            UserSensorSensor userSensor = sensor.asUserSensor();
            if (userSensor.width() != 100) {
                builder.add("width", (Object)new FrameBuilder(new String[]{"width"}).add("value", (Object)userSensor.width()));
            }
            if (userSensor.height() != 100) {
                builder.add("height", (Object)new FrameBuilder(new String[]{"height"}).add("value", (Object)userSensor.height()));
            }
        }
        return builder.toFrame();
    }

    private Frame parent(Sensor sensor) {
        if (sensor.isPoll()) {
            return this.poll(sensor.asPoll());
        }
        if (sensor.isFormEdition()) {
            return this.formEdition(sensor.asFormEdition());
        }
        if (sensor.isDocumentEdition()) {
            return this.documentEdition(sensor.asDocumentEdition());
        }
        if (sensor.isDocumentSignature()) {
            return this.documentSignature(sensor.asDocumentSignature());
        }
        return new FrameBuilder().toFrame();
    }

    private Frame poll(PollSensor sensor) {
        return new FrameBuilder(new String[]{"poll"}).add("defaultOption", (Object)(sensor.defaultOption() == null ? "" : sensor.defaultOption())).add("eventMethod", ((Feeder)sensor.core$().ownerAs(Feeder.class)).eventTypes().stream().map(Layer::name$).toArray(String[]::new)).add("option", (Object)this.frameOf(sensor.optionList())).toFrame();
    }

    private Frame[] frameOf(List<PollSensor.Option> options) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (PollSensor.Option option : options) {
            FrameBuilder builder = new FrameBuilder(new String[]{"option"}).add("value", (Object)option.value()).add("event", (Object)option.event().name$());
            if (!option.optionList().isEmpty()) {
                builder.add("option", (Object)this.frameOf(option.optionList()));
            }
            frames.add(builder.toFrame());
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame formEdition(FormEditionSensor sensor) {
        return new FrameBuilder(new String[]{"formEdition"}).add("path", (Object)sensor.path()).toFrame();
    }

    private Frame documentEdition(DocumentEditionSensor sensor) {
        return new FrameBuilder(new String[]{"documentEdition"}).add("mode", (Object)sensor.mode().name()).toFrame();
    }

    private Frame documentSignature(DocumentSignatureSensor sensor) {
        return new FrameBuilder(new String[]{"documentSignature"}).add("signType", (Object)sensor.signType().name()).add("signFormat", (Object)sensor.signFormat().name()).toFrame();
    }

    private String composedType(Schema schema, String subdomain) {
        return this.fullDomain(subdomain) + schema.name$().toLowerCase();
    }

    private String fullDomain(String subdomain) {
        return (this.domain.isEmpty() ? "" : this.domain + ".") + (subdomain.isEmpty() ? "" : subdomain + ".");
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

