/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.NessJMXOperationsTemplate;
import io.intino.konos.builder.codegeneration.datalake.ReflowAssistantTemplate;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;

public class NessJMXOperationsRenderer {
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final boolean hasGraph;
    private File src;

    public NessJMXOperationsRenderer(File gen, File src, String packageName, String boxName, boolean hasGraph) {
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.hasGraph = hasGraph;
    }

    public void execute() {
        FrameBuilder builder = new FrameBuilder(new String[]{"operations"}).add("package", (Object)this.packageName).add("box", (Object)this.boxName);
        if (this.hasGraph) {
            builder.add("graph");
        }
        Commons.writeFrame(new File(this.gen, "datalake"), "NessOperations", this.operationsTemplate().render((Object)builder.toFrame()));
        Commons.writeFrame(new File(this.gen, "datalake"), "NessOperationsMBean", this.operationsTemplate().render((Object)builder.add("interface").toFrame()));
        if (!Commons.javaFile(new File(this.src, "datalake"), "ReflowAssistant").exists()) {
            Commons.writeFrame(new File(this.src, "datalake"), "ReflowAssistant", this.assistantTemplate().render((Object)builder.toFrame()));
        }
    }

    private Template operationsTemplate() {
        return Formatters.customize(new NessJMXOperationsTemplate());
    }

    private Template assistantTemplate() {
        return Formatters.customize(new ReflowAssistantTemplate());
    }
}

