/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import io.intino.konos.builder.codegeneration.accessor.ui.UIAccessorRenderer;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.project.configuration.ConfigurationManager;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UIAccessorCreator {
    private final Project project;
    private final Module javaModule;
    private final List<UIService> serviceList;
    private String parent;

    public UIAccessorCreator(Module module, KonosGraph graph, String parent) {
        this.project = module == null ? null : module.getProject();
        this.javaModule = module;
        this.serviceList = graph.uIServiceList();
        this.parent = parent;
    }

    public void execute() {
        if (this.javaModule == null) {
            return;
        }
        for (UIService service : this.serviceList) {
            Module webModule = this.getOrCreateModule(service);
            UIAccessorRenderer renderer = new UIAccessorRenderer(this.javaModule, webModule, service, this.parent);
            renderer.execute();
            boolean created = renderer.createConfigurationFile();
            if (!created) continue;
            ConfigurationManager.register((Module)webModule, (Configuration)ConfigurationManager.newExternalProvider((Module)webModule));
        }
    }

    private Module getOrCreateModule(UIService service) {
        return (Module)ApplicationManager.getApplication().runWriteAction(() -> {
            Module[] modules;
            ModuleManager manager = ModuleManager.getInstance((Project)this.project);
            for (Module m : modules = manager.getModules()) {
                if (!m.getName().equals(this.toSnakeCase(service.name$()))) continue;
                this.addModuleDependency(m);
                return m;
            }
            Module webModule = manager.newModule(this.modulePath(service), "WEB_MODULE");
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)webModule).getModifiableModel();
            File parent = new File(webModule.getModuleFilePath()).getParentFile();
            parent.mkdirs();
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)parent, (boolean)true);
            ContentEntry contentEntry = vFile != null ? model.addContentEntry(vFile) : model.addContentEntry(parent.getAbsolutePath());
            this.addExcludeFiles(parent, contentEntry);
            model.commit();
            this.addModuleDependency(webModule);
            return webModule;
        });
    }

    private void addExcludeFiles(File parent, ContentEntry contentEntry) {
        File lib = new File(parent, "lib");
        lib.mkdirs();
        contentEntry.addExcludeFolder(Objects.requireNonNull(VfsUtil.findFileByIoFile((File)lib, (boolean)true)));
    }

    private String toSnakeCase(String name) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1-$2";
        return name.replaceAll(regex, replacement).toLowerCase();
    }

    @NotNull
    private String modulePath(UIService service) {
        String string = this.project.getBasePath() + File.separator + this.toSnakeCase(service.name$()) + File.separator + this.toSnakeCase(service.name$()) + ".iml";
        if (string == null) {
            UIAccessorCreator.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void addModuleDependency(Module webModule) {
        LibraryTable table;
        LibraryTable libraryTable = table = this.javaModule != null ? LibraryTablesRegistrar.getInstance().getLibraryTable(this.javaModule.getProject()) : null;
        if (table == null) {
            return;
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.javaModule);
        ModifiableRootModel modifiableModel = manager.getModifiableModel();
        if (manager.isDependsOn(webModule)) {
            return;
        }
        modifiableModel.addModuleOrderEntry(webModule);
        modifiableModel.commit();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/accessor/ui/UIAccessorCreator", "modulePath"));
    }
}

