/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jms;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.accessor.jms.JMSAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.jms.JMSService;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JMSAccessorRenderer {
    private final JMSService service;
    private File destination;
    private String packageName;

    public JMSAccessorRenderer(JMSService application, File destination, String packageName) {
        this.service = application;
        this.destination = destination;
        this.packageName = packageName;
    }

    public void execute() {
        new SchemaRenderer(this.service.graph(), this.destination, this.packageName, new HashMap<String, String>()).execute();
        this.processService(this.service);
    }

    private void processService(JMSService jmsService) {
        FrameBuilder builder = new FrameBuilder(new String[]{"accessor"});
        builder.add("name", (Object)jmsService.name$());
        builder.add("package", (Object)this.packageName);
        if (!jmsService.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName).toFrame());
        }
        List requests = jmsService.core$().findNode(JMSService.Request.class);
        Set<String> customParameters = this.extractCustomParameters(requests);
        builder.add("request", requests.stream().map(request -> this.processRequest((JMSService.Request)((Object)request), customParameters).toFrame()).toArray(Frame[]::new));
        for (String parameter : customParameters) {
            builder.add("custom", (Object)parameter);
        }
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)jmsService.name$()) + "Accessor", this.getTemplate().render((Object)builder.toFrame()));
    }

    private Set<String> extractCustomParameters(List<JMSService.Request> requests) {
        HashSet<String> set = new HashSet<String>();
        for (JMSService.Request request : requests) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private FrameBuilder processRequest(JMSService.Request request, Set<String> customParameters) {
        FrameBuilder builder = new FrameBuilder(new String[]{"request"}).add("name", (Object)request.name$()).add("queue", (Object)request.path()).add("parameter", (Object)this.parameters(request.parameterList())).add("messageType", (Object)this.messageType(request.parameterList()));
        if (request.response() != null) {
            builder.add("reply");
            FrameBuilder reply = new FrameBuilder();
            if (request.response().isList()) {
                reply.add("list");
            }
            builder.add("reply", (Object)reply.add("reply", (Object)((Object)((Object)request.response().asType())).getClass().getSimpleName()).add("value", (Object)request.response().asType().type()));
        }
        customParameters.forEach(parameter -> builder.add("custom", parameter));
        return builder;
    }

    private String messageType(List<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            if (!parameter.isFile()) continue;
            return "Bytes";
        }
        return "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new FrameBuilder().add("parameter", (Object)((Object)((Object)parameter.asType())).getClass().getSimpleName()).add("name", (Object)parameter.name$()).add("type", (Object)parameter.asType().type()).toFrame();
    }

    private Template getTemplate() {
        return new JMSAccessorTemplate().add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString())).add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value).add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

