/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ParameterPublisher;
import io.intino.konos.builder.codegeneration.datalake.feeder.FeederRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AbstractBoxRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final KonosGraph graph;
    private final Configuration configuration;
    private final String parent;
    private final boolean hasModel;
    private final Set<String> customParameters;

    AbstractBoxRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean hasModel) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.hasModel = hasModel;
        this.customParameters = new HashSet<String>();
    }

    public void execute() {
        FrameBuilder builder = new FrameBuilder(new String[]{"box"});
        String name = this.name();
        builder.add("name", (Object)name);
        builder.add("package", (Object)this.packageName);
        if (this.hasModel) {
            builder.add("tara", (Object)name);
        }
        this.parent(builder);
        this.services(builder, name);
        this.tasks(builder, name);
        this.dataLake(builder, name);
        Commons.writeFrame(this.gen, "AbstractBox", this.template().render((Object)builder.toFrame()));
        this.notifyNewParameters();
    }

    private void notifyNewParameters() {
        new ParameterPublisher((LegioConfiguration)this.configuration).publish(this.customParameters);
    }

    private void tasks(FrameBuilder builder, String name) {
        if (!this.graph.taskList().isEmpty()) {
            builder.add("task", (Object)new FrameBuilder(new String[]{"task"}).add("configuration", (Object)name).toFrame());
        }
    }

    private void dataLake(FrameBuilder root, String name) {
        if (!this.graph.nessClientList().isEmpty()) {
            NessClient client = this.graph.nessClientList().get(0);
            FrameBuilder datalake = new FrameBuilder(new String[]{"dataLake"}).add("mode", (Object)this.graph.nessClient(0).mode().name()).add("name", (Object)this.graph.nessClient(0).name$()).add("package", (Object)this.packageName).add("configuration", (Object)name);
            datalake.add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(client.url()) ? "custom" : "standard"}).add("value", (Object)client.url()).toFrame());
            datalake.add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(client.user()) ? "custom" : "standard"}).add("value", (Object)client.user()).toFrame());
            datalake.add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(client.password()) ? "custom" : "standard"}).add("value", (Object)client.password()).toFrame());
            datalake.add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(client.clientID()) ? "custom" : "standard"}).add("value", (Object)client.clientID()).toFrame());
            datalake.add("feeder", client.feederList().stream().map(this::frameOf).toArray(Frame[]::new));
            if (client.requireConnection()) {
                datalake.add("requireConnection");
            }
            if (!this.graph.procedureList().isEmpty()) {
                datalake.add("procedure", (Object)new FrameBuilder().add("package", (Object)this.packageName).add("configuration", (Object)name).toFrame());
            }
            if (this.hasModel) {
                datalake.add("nessOperations", (Object)new FrameBuilder().add("package", (Object)this.packageName).add("configuration", (Object)name).toFrame());
            }
            root.add("dataLake", (Object)datalake);
        }
    }

    private Frame frameOf(Feeder feeder) {
        return new FrameBuilder(new String[]{"feeder"}).add("package", (Object)this.packageName).add("name", (Object)FeederRenderer.name(feeder)).add("box", (Object)this.name()).toFrame();
    }

    private void services(FrameBuilder builder, String name) {
        if (!this.graph.jMSServiceList().isEmpty()) {
            builder.add("jms", (Object)"");
        }
        this.rest(builder, name);
        this.jms(builder, name);
        this.jmx(builder, name);
        this.slackServices(builder, name);
        if (!this.graph.rESTServiceList().isEmpty() || !this.graph.uIServiceList().isEmpty()) {
            builder.add("spark", (Object)"stop");
        }
        this.ui(builder, name);
    }

    private void rest(FrameBuilder frame, String name) {
        for (RESTService service : this.graph.rESTServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "rest"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(service.port()) ? "custom" : "standard"}).add("value", (Object)service.port())).toFrame());
        }
    }

    private void jms(FrameBuilder frame, String name) {
        for (JMSService service : this.graph.jMSServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jms"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(service.user()) ? "custom" : "standard"}).add("value", (Object)service.user()).toFrame()).add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(service.password()) ? "custom" : "standard"}).add("value", (Object)service.password()).toFrame()).add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(service.url()) ? "custom" : "standard"}).add("value", (Object)service.url()).toFrame()).toFrame());
        }
    }

    private void jmx(FrameBuilder frame, String name) {
        for (JMXService service : this.graph.jMXServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jmx"}).add("name", (Object)service.name$()).add("configuration", (Object)name).toFrame());
        }
    }

    private void slackServices(FrameBuilder frame, String name) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "slack"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service)).toFrame());
        }
    }

    private void ui(FrameBuilder builder, String name) {
        if (!this.graph.uIServiceList().isEmpty()) {
            FrameBuilder uiFrame = new FrameBuilder();
            if (this.parent != null) {
                uiFrame.add("parent", (Object)this.parent);
            }
            builder.add("hasUi", (Object)uiFrame);
            builder.add("uiAuthentication", (Object)uiFrame);
            builder.add("uiEdition", (Object)uiFrame);
            builder.add("service", this.graph.uIServiceList().stream().map(s -> this.ui((UIService)((Object)s), name)).toArray(Frame[]::new));
        }
    }

    private Frame ui(UIService service, String name) {
        FrameBuilder builder = new FrameBuilder(new String[]{"service", "ui"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)new FrameBuilder(new String[]{this.isCustom(service.port()) ? "custom" : "standard"}).add("value", (Object)service.port()).toFrame());
        if (service.authentication() != null) {
            builder.add("authentication", (Object)new FrameBuilder(new String[]{this.isCustom(service.authentication().by()) ? "custom" : "standard"}).add("value", (Object)service.authentication().by()).toFrame());
        }
        if (service.edition() != null) {
            builder.add("edition", (Object)new FrameBuilder(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).add("value", (Object)service.edition().by()).toFrame());
        }
        service.useList().forEach(use -> builder.add("use", (Object)(use.className() + "Service")));
        return builder.toFrame();
    }

    @NotNull
    private Frame parameter(SlackBotService service) {
        Frame frame = new FrameBuilder(new String[]{this.isCustom(service.token()) ? "custom" : "standard"}).add("value", (Object)service.token()).toFrame();
        if (frame == null) {
            AbstractBoxRenderer.$$$reportNull$$$0(0);
        }
        return frame;
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.customParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(FrameBuilder builder) {
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            builder.add("parent", (Object)this.parent).add("hasParent", (Object)"");
        } else {
            builder.add("hasntParent", (Object)"");
        }
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(new AbstractBoxTemplate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/AbstractBoxRenderer", "parameter"));
    }
}

