/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.actions.AccessorPomTemplate;
import io.intino.konos.builder.actions.SelectServicesDialog;
import io.intino.konos.builder.codegeneration.accessor.jms.JMSAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.jmx.JMXAccessorRenderer;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.plugin.toolwindows.output.IntinoTopics;
import io.intino.plugin.toolwindows.output.MavenListener;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.actions.utils.FileSystemUtils;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

class AccessorsPublisher {
    private static final Logger LOG = Logger.getInstance((String)"Publishing Accessor:");
    private static final String KONOS = "konos";
    private static final String ACCESSOR = "-accessor";
    private final Module module;
    private final KonosGraph graph;
    private final String generationPackage;
    private StringBuilder log = new StringBuilder();
    private File root;
    private Configuration configuration;

    AccessorsPublisher(Module module, KonosGraph graph, String generationPackage) {
        this.module = module;
        this.configuration = TaraUtil.configurationOf((Module)module);
        this.graph = graph;
        this.generationPackage = generationPackage;
        try {
            this.root = Files.createTempDirectory(KONOS, new FileAttribute[0]).toFile();
            FileSystemUtils.removeDir((File)this.root);
        }
        catch (IOException e) {
            this.root = null;
        }
    }

    void publish() {
        if (this.configuration == null) {
            return;
        }
        if (this.graph == null) {
            this.notify("Box has errors. Check problems view for more information", NotificationType.INFORMATION);
            return;
        }
        List<Service> services = this.collectServices();
        if (services.isEmpty()) {
            this.notify("No services found in module", NotificationType.INFORMATION);
            return;
        }
        if (services.size() > 1) {
            services = new SelectServicesDialog(WindowManager.getInstance().suggestParentWindow(this.module.getProject()), services).showAndGet();
        }
        try {
            this.createSources(services);
            if (this.configuration.distributionReleaseRepository() == null) {
                this.notify("There isn't distribution repository defined", NotificationType.ERROR);
                return;
            }
            this.mvn(services, this.configuration);
        }
        catch (IOException | MavenInvocationException e) {
            this.notifyError(e.getMessage());
            LOG.error(e.getMessage());
        }
    }

    private List<Service> collectServices() {
        return this.graph.serviceList().stream().filter(s -> !s.isUI() && !s.isSlackBot()).collect(Collectors.toList());
    }

    private void mvn(List<Service> services, Configuration conf) throws MavenInvocationException, IOException {
        File[] files = this.root.listFiles(File::isDirectory);
        for (File file : files != null ? files : new File[]{}) {
            Service service = services.stream().filter(s -> s.name$().equals(file.getName())).findFirst().orElse(null);
            File pom = this.createPom(file, service, conf.groupId(), file.getName() + ACCESSOR, conf.version());
            InvocationResult result = this.invoke(pom);
            if (result != null && result.getExitCode() != 0) {
                if (result.getExecutionException() != null) {
                    throw new IOException("Failed to publish accessor.", (Throwable)result.getExecutionException());
                }
                throw new IOException("Failed to publish accessor. Exit code: " + result.getExitCode());
            }
            if (result == null) {
                throw new IOException("Failed to publish accessor. Maven HOME not found");
            }
            this.notifySuccess(this.configuration, file.getName());
        }
    }

    private InvocationResult invoke(File pom) throws MavenInvocationException, IOException {
        String ijMavenHome = MavenProjectsManager.getInstance((Project)this.module.getProject()).getGeneralSettings().getMavenHome();
        InvocationRequest request = new DefaultInvocationRequest().setPomFile(pom).setGoals(Arrays.asList("clean", "install", "deploy"));
        File mavenHome = MavenUtil.resolveMavenHomeDirectory((String)ijMavenHome);
        if (mavenHome == null) {
            return null;
        }
        LOG.info("Maven HOME: " + mavenHome.getAbsolutePath());
        Invoker invoker = new DefaultInvoker().setMavenHome(mavenHome);
        this.log(invoker);
        this.config(request, mavenHome);
        return invoker.execute(request);
    }

    private void log(Invoker invoker) throws IOException {
        invoker.setErrorHandler(arg_0 -> ((Logger)LOG).error(arg_0));
        invoker.setOutputHandler(this::publish);
    }

    private void publish(String line) {
        if (this.module.getProject().isDisposed()) {
            return;
        }
        MessageBus messageBus = this.module.getProject().getMessageBus();
        MavenListener mavenListener = (MavenListener)messageBus.syncPublisher(IntinoTopics.BUILD_CONSOLE);
        mavenListener.println(line);
        MessageBusConnection connect = messageBus.connect();
        connect.deliverImmediately();
        connect.disconnect();
    }

    private void config(InvocationRequest request, File mavenHome) {
        File mvn = new File(mavenHome, "bin" + File.separator + "mvn");
        mvn.setExecutable(true);
        Sdk sdk = ModuleRootManager.getInstance((Module)this.module).getSdk();
        if (sdk != null && sdk.getHomePath() != null) {
            request.setJavaHome(new File(sdk.getHomePath()));
        }
    }

    private void createSources(List<Service> services) {
        this.rest(services);
        this.jms(services);
        this.jmx(services);
    }

    private void rest(List<Service> services) {
        services.stream().filter(Service::isREST).forEach(s -> {
            File sourcesDestiny = new File(new File(this.root, s.name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new RESTAccessorRenderer(s.asREST(), sourcesDestiny, this.generationPackage).execute();
        });
    }

    private void jms(List<Service> services) {
        ArrayList sources = new ArrayList();
        services.stream().filter(Service::isJMS).forEach(s -> {
            File sourcesDestiny = new File(new File(this.root, s.asJMS().name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new JMSAccessorRenderer(s.asJMS(), sourcesDestiny, this.generationPackage).execute();
        });
    }

    private void jmx(List<Service> services) {
        services.stream().filter(Service::isJMX).forEach(s -> {
            File sourcesDestiny = new File(new File(this.root, s.name$() + File.separator + "src"), this.generationPackage.replace(".", File.separator));
            sourcesDestiny.mkdirs();
            new JMXAccessorRenderer(s.asJMX(), sourcesDestiny, this.generationPackage).execute();
        });
    }

    private File createPom(File root, Service service, String group, String artifact, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)artifact).add("version", (Object)version);
        this.configuration.releaseRepositories().forEach((u, i) -> builder.add("repository", (Object)this.createRepositoryFrame((String)u, (String)i, "release")));
        AbstractMap.SimpleEntry distroRepo = this.configuration.distributionReleaseRepository();
        builder.add("repository", (Object)this.createRepositoryFrame((String)distroRepo.getKey(), (String)distroRepo.getValue(), "distribution"));
        FrameBuilder depBuilder = new FrameBuilder((String[])service.core$().conceptList().stream().map(s -> s.id().split("#")[0].toLowerCase()).toArray(String[]::new)).add("value", (Object)"");
        builder.add("dependency", (Object)depBuilder.toFrame());
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new AccessorPomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private Frame createRepositoryFrame(String url, String id, String type) {
        return new FrameBuilder(new String[]{"repository", "release", type}).add("name", (Object)id).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)url).toFrame();
    }

    private void notifySuccess(Configuration conf, String app) {
        NotificationGroup balloon = NotificationGroup.toolWindowGroup((String)"Tara Language", (String)"Balloon");
        balloon.createNotification("Accessors generated and uploaded", this.message(), NotificationType.INFORMATION, (n, e) -> {
            StringSelection selection = new StringSelection(this.newDependency(conf, app));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, selection);
        }).setImportant(true).notify(this.module.getProject());
    }

    private void notify(String message, NotificationType type) {
        Notifications.Bus.notify((Notification)new Notification("Konos", message, this.module.getName(), type), (Project)this.module.getProject());
    }

    @NotNull
    private String message() {
        return "<a href=\"#\">Copy maven dependency</a>";
    }

    @NotNull
    private String newDependency(Configuration conf, String app) {
        String string = "<dependency>\n    <groupId>" + conf.groupId().toLowerCase() + "</groupId>\n    <artifactId>" + app.toLowerCase() + ACCESSOR + "</artifactId>\n    <version>" + conf.version() + "</version>\n</dependency>";
        if (string == null) {
            AccessorsPublisher.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void notifyError(String message) {
        String result = this.log.toString();
        Notifications.Bus.notify((Notification)new Notification("Konos", "Accessor cannot be published. ", message + "\n" + result, NotificationType.ERROR), (Project)this.module.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/actions/AccessorsPublisher", "newDependency"));
    }
}

