/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.swagger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intino.konos.builder.codegeneration.swagger.SwaggerSpec;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OpenApiDescriptor {
    private final RESTService service;
    private final List<Schema> schemas;

    public OpenApiDescriptor(RESTService service) {
        this.service = service;
        this.schemas = new ArrayList<Schema>();
    }

    public String createJSONDescriptor() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)this.create());
    }

    private SwaggerSpec create() {
        SwaggerSpec spec = new SwaggerSpec();
        spec.basePath = this.service.basePath().isEmpty() ? "/" : this.service.basePath() + this.version();
        spec.host = this.service.host().contains("{") ? "www.example.org" : this.service.host();
        spec.schemes = this.service.protocols().stream().map(Enum::name).collect(Collectors.toList());
        spec.paths = new LinkedHashMap<String, SwaggerSpec.Path>();
        spec.info = this.createInfo(this.service.info());
        for (RESTService.Resource resource : this.service.resourceList()) {
            spec.paths.put(resource.path(), this.createPath(resource));
        }
        spec.definitions = this.createDefinitions();
        if (this.service.authenticatedWithToken() != null) {
            spec.securityDefinitions = new HashMap<String, SwaggerSpec.SecurityDefinition>();
            spec.securityDefinitions.put("basic", new SwaggerSpec.SecurityDefinition().type("basic"));
            spec.security = new ArrayList<SwaggerSpec.SecuritySchema>();
            spec.security.add(new SwaggerSpec.SecuritySchema().basic());
        }
        return spec;
    }

    @NotNull
    private String version() {
        if (this.service.info() == null || this.service.info().version() == null) {
            if ("" == null) {
                OpenApiDescriptor.$$$reportNull$$$0(0);
            }
            return "";
        }
        String string = "/" + this.service.info().version();
        if (string == null) {
            OpenApiDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private SwaggerSpec.Info createInfo(RESTService.Info info) {
        return info == null ? null : new SwaggerSpec.Info(info.version(), info.title(), info.description(), info.termsOfService(), info.contact() == null ? null : new SwaggerSpec.Info.Contact(info.contact().name$(), info.contact().email(), info.contact().url()), info.license() == null ? null : new SwaggerSpec.Info.License(info.license().name$(), info.license().url()));
    }

    private SwaggerSpec.Path createPath(RESTService.Resource resource) {
        SwaggerSpec.Path path = new SwaggerSpec.Path();
        for (RESTService.Resource.Operation op : resource.operationList()) {
            SwaggerSpec.Path.Operation operation = new SwaggerSpec.Path.Operation();
            operation.description = op.description().isEmpty() ? null : op.description();
            operation.summary = op.summary().isEmpty() ? null : op.summary();
            operation.operationId = op.name$();
            operation.tags = op.tags().isEmpty() ? null : op.tags();
            operation.parameters = this.createParameters(op.parameterList());
            this.addResponse(operation.responses, op.response());
            this.addResponse(operation.responses, op.exceptionList());
            this.addOperationToPath(path, operation, ((Object)((Object)op)).getClass().getSimpleName());
        }
        return path;
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, Response response) {
        SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
        if (response != null) {
            swaggerResponse.description = response.description();
            if (response.isObject()) {
                swaggerResponse.schema = new SwaggerSpec.Schema(null, "#/definitions/" + response.asObject().schema().name$());
                this.schemas.add(response.asObject().schema());
            }
        }
        responses.put(response == null ? "200" : response.code(), swaggerResponse);
    }

    private void addResponse(Map<String, SwaggerSpec.Path.Operation.Response> responses, List<Exception> exceptions) {
        for (Exception exception : exceptions) {
            SwaggerSpec.Path.Operation.Response swaggerResponse = new SwaggerSpec.Path.Operation.Response();
            swaggerResponse.description = exception.description();
            if (exception.isObject()) {
                swaggerResponse.schema = new SwaggerSpec.Schema(null, "#/definitions/" + exception.asObject().schema().name$());
                this.schemas.add(exception.asObject().schema());
            }
            responses.put(exception.code().value(), swaggerResponse);
        }
    }

    private void addOperationToPath(SwaggerSpec.Path path, SwaggerSpec.Path.Operation operation, String name) {
        switch (name) {
            case "Get": {
                path.get = operation;
                break;
            }
            case "Post": {
                path.post = operation;
                break;
            }
            case "patch": {
                path.patch = operation;
                break;
            }
            case "Put": {
                path.put = operation;
                break;
            }
            case "Delete": {
                path.delete = operation;
                break;
            }
            default: {
                path.head = operation;
            }
        }
    }

    private List<SwaggerSpec.Path.Operation.Parameter> createParameters(List<RESTService.Resource.Parameter> parameters) {
        ArrayList<SwaggerSpec.Path.Operation.Parameter> list = new ArrayList<SwaggerSpec.Path.Operation.Parameter>();
        for (RESTService.Resource.Parameter parameter : parameters) {
            SwaggerSpec.Path.Operation.Parameter swaggerParameter = new SwaggerSpec.Path.Operation.Parameter();
            swaggerParameter.description = parameter.description();
            swaggerParameter.in = parameter.in().name();
            swaggerParameter.name = parameter.name$();
            swaggerParameter.type = this.parameterType(parameter.in(), parameter.asType());
            boolean bl = swaggerParameter.required = parameter.in() == RESTService.Resource.Parameter.In.path || parameter.isRequired();
            if (parameter.isObject()) {
                this.schemas.add(parameter.asObject().schema());
                if (parameter.in() == RESTService.Resource.Parameter.In.body) {
                    swaggerParameter.schema = new SwaggerSpec.Schema(null, "#/definitions/" + parameter.asObject().schema().name$());
                }
            }
            list.add(swaggerParameter);
        }
        return list.isEmpty() ? null : list;
    }

    private String parameterType(RESTService.Resource.Parameter.In in, TypeData typeData) {
        String type = typeData.type();
        if (typeData.i$(LongIntegerData.class) || type.equals("java.time.Instant") || type.equalsIgnoreCase("double")) {
            return "number";
        }
        if (typeData.i$(FileData.class) || type.endsWith("Resource")) {
            return "file";
        }
        if (type.equalsIgnoreCase("java.lang.enum")) {
            return "string";
        }
        if (typeData.i$(ObjectData.class)) {
            if (in == RESTService.Resource.Parameter.In.body) {
                return null;
            }
            return "string";
        }
        return type.toLowerCase();
    }

    private String transform(TypeData typeData) {
        String type = typeData.type();
        if (typeData.i$(LongIntegerData.class) || type.equals("java.time.Instant") || type.equalsIgnoreCase("double")) {
            return "number";
        }
        if (typeData.i$(FileData.class) || type.endsWith("Resource")) {
            return "file";
        }
        if (type.equalsIgnoreCase("java.lang.enum")) {
            return "string";
        }
        if (typeData.i$(ObjectData.class)) {
            return "object";
        }
        return type.toLowerCase();
    }

    private Map<String, SwaggerSpec.Definition> createDefinitions() {
        LinkedHashMap<String, SwaggerSpec.Definition> map = new LinkedHashMap<String, SwaggerSpec.Definition>();
        for (Schema schema : this.schemas) {
            SwaggerSpec.Definition definition = new SwaggerSpec.Definition();
            definition.required = schema.attributeList().stream().filter(Schema.Attribute::isRequired).map(Layer::name$).collect(Collectors.toList());
            definition.properties = this.toMap(schema.attributeList());
            map.put(schema.name$(), definition);
        }
        return map;
    }

    private Map<String, SwaggerSpec.Definition.Property> toMap(List<Schema.Attribute> attributes) {
        LinkedHashMap<String, SwaggerSpec.Definition.Property> map = new LinkedHashMap<String, SwaggerSpec.Definition.Property>();
        for (Schema.Attribute attribute : attributes) {
            map.put(attribute.name$(), this.propertyFrom(attribute));
        }
        return map;
    }

    @NotNull
    private SwaggerSpec.Definition.Property propertyFrom(Schema.Attribute attribute) {
        SwaggerSpec.Definition.Property property = new SwaggerSpec.Definition.Property();
        property.type = this.transform(attribute.asType());
        SwaggerSpec.Definition.Property property2 = property;
        if (property2 == null) {
            OpenApiDescriptor.$$$reportNull$$$0(2);
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "io/intino/konos/builder/codegeneration/swagger/OpenApiDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyFrom";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

