/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public abstract class UIPrototypeRenderer
extends UIRenderer {
    private final String name;

    protected UIPrototypeRenderer(String name, String box, String packageName) {
        super(box, packageName);
        this.name = name;
    }

    @Override
    public Frame buildFrame() {
        return new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{this.name}).addSlot("package", new String[]{this.packageName});
    }

    public final void write(File src, File gen) {
        Frame frame = this.buildFrame();
        this.writeSrc(src, frame);
        this.writeGen(gen, frame);
    }

    private void writeSrc(File file, Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)this.name);
        File sourceFile = Commons.javaFile(new File(file, "displays"), newDisplay);
        if (!sourceFile.exists()) {
            Commons.writeFrame(new File(file, "displays"), newDisplay, this.srcTemplate().format((Object)frame));
        } else {
            Updater updater = this.updater(newDisplay, sourceFile);
            if (updater != null) {
                updater.update();
            }
        }
    }

    private void writeGen(File file, Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)("Abstract" + Commons.firstUpperCase(this.name)));
        Commons.writeFrame(new File(file, "displays"), newDisplay, this.genTemplate().format((Object)frame.addTypes(new String[]{"gen"})));
    }

    protected abstract Template srcTemplate();

    protected abstract Template genTemplate();

    protected abstract Updater updater(String var1, File var2);
}

