/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.jms;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class JMSAccessorTemplate
extends Template {
    protected JMSAccessorTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new JMSAccessorTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "accessor")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(";\n\nimport io.intino.alexandria.exceptions.*;\nimport io.intino.alexandria.jms.QueueProducer;\nimport com.google.gson.Gson;\n\nimport java.util.List;\nimport javax.jms.*;\n")).add((Token.Body)this.mark("schemaImport", new String[0])).add((Token.Body)this.literal("\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Accessor {\n\n\tprivate final Session session;\n\t")).add((Token.Body)this.mark("custom", new String[]{"field"}).multiple("\n")).add((Token.Body)this.literal("\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Accessor(Session session")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("custom", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") {\n\t\tthis.session = session;\n\t\t")).add((Token.Body)this.mark("custom", new String[]{"assign"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\t")).add((Token.Body)this.mark("request", new String[0]).multiple("\n\n")).add((Token.Body)this.literal("\n\n\t")).add((Token.Body)this.mark("request", new String[]{"interface"}).multiple("\n\n")).add((Token.Body)this.literal("\n\n\tprivate static String createRandomString() {\n\t\tjava.util.Random random = new java.util.Random(System.currentTimeMillis());\n\t\tlong randomLong = random.nextLong();\n\t\treturn Long.toHexString(randomLong);\n\t}\n\n\tprivate byte[] toByteArray(java.io.InputStream stream) {\n\t\ttry {\n\t\t\tjava.io.ByteArrayOutputStream buffer = new java.io.ByteArrayOutputStream();\n\t\t\tint nRead;\n\t\t\tbyte[] data = new byte[16384];\n\t\t\twhile ((nRead = stream.read(data, 0, data.length)) != -1) {\n\t\t\t\tbuffer.write(data, 0, nRead);\n\t\t\t}\n\t\t\tbuffer.flush();\n\t\t\treturn buffer.toByteArray();\n\t\t} catch (java.io.IOException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);\n\t\t}\n\t\treturn new byte[0];\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "request & reply"), this.condition("trigger", "interface")}).add((Token.Body)this.literal("public interface ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Response extends MessageListener {\n\n\tvoid callback(")).add((Token.Body)this.mark("reply", new String[]{"return"})).add((Token.Body)this.literal(" value);\n\n\tdefault void onMessage(Message message) {\n\t\ttry {\n\t\t\t")).add((Token.Body)this.mark("reply", new String[0])).add((Token.Body)this.literal("\n\n\t\t} catch (JMSException e) {\n\t\t\tio.intino.alexandria.logger.Logger.error(e.getMessage(), e);\n\t\t}\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "request"), this.condition("trigger", "interface")}), this.rule().add(new Condition[]{this.condition("type", "request & reply")}).add((Token.Body)this.literal("public MessageConsumer ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("(")).add((Token.Body)this.expression().add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", ")).add((Token.Body)this.literal(", "))).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Response callback) throws JMSException {\n\tDestination temporaryQueue = session.createTemporaryQueue();\n\tMessageConsumer consumer = session.createConsumer(temporaryQueue);\n\tconsumer.setMessageListener(callback);\n\tfinal ")).add((Token.Body)this.mark("messageType", new String[0])).add((Token.Body)this.literal("Message message = session.create")).add((Token.Body)this.mark("messageType", new String[0])).add((Token.Body)this.literal("Message();\n\tmessage.setJMSReplyTo(temporaryQueue);\n\tmessage.setJMSCorrelationID(createRandomString());\n\tfill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"name"}).multiple(", "))).add((Token.Body)this.literal(");\n\tQueueProducer producer = new QueueProducer(session, \"")).add((Token.Body)this.mark("queue", new String[0])).add((Token.Body)this.literal("\"")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[0]).multiple(""))).add((Token.Body)this.literal(");\n\tproducer.produce(message);\n\tproducer.close();\n\treturn consumer;\n}\n\nprivate void fill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(")).add((Token.Body)this.mark("messageType", new String[0])).add((Token.Body)this.literal("Message message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") throws JMSException {\n\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n")).add((Token.Body)this.literal("\n}")), this.rule().add(new Condition[]{this.not(this.condition("type", "parameter")), this.condition("trigger", "field")}).add((Token.Body)this.literal("private String ")).add((Token.Body)this.mark("value", new String[]{"validname"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.not(this.condition("type", "parameter")), this.condition("trigger", "signature")}).add((Token.Body)this.literal("String ")).add((Token.Body)this.mark("value", new String[]{"validname"})), this.rule().add(new Condition[]{this.not(this.condition("type", "parameter")), this.condition("trigger", "assign")}).add((Token.Body)this.literal("this.")).add((Token.Body)this.mark("value", new String[]{"validname"})).add((Token.Body)this.literal(" = ")).add((Token.Body)this.mark("value", new String[]{"validname"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.not(this.condition("type", "parameter")), this.condition("trigger", "custom")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", this.")).add((Token.Body)this.mark("value", new String[]{"validname"})).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("type", "request")}).add((Token.Body)this.literal("public void ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("(")).add((Token.Body)this.expression().add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") throws JMSException {\n\tfinal TextMessage message = session.createTextMessage();\n\tfill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"name"}).multiple(", "))).add((Token.Body)this.literal(");\n\tQueueProducer producer = new QueueProducer(session, \"")).add((Token.Body)this.mark("queue", new String[0])).add((Token.Body)this.literal("\");\n\tnew QueueProducer(session, \"")).add((Token.Body)this.mark("queue", new String[0])).add((Token.Body)this.literal("\").produce(message);\n\tproducer.close();\n}\n\nprivate void fill")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(")).add((Token.Body)this.mark("messageType", new String[0])).add((Token.Body)this.literal("Message message")).add((Token.Body)this.expression().add((Token.Body)this.literal(", ")).add((Token.Body)this.mark("parameter", new String[]{"signature"}).multiple(", "))).add((Token.Body)this.literal(") throws JMSException {\n\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n")).add((Token.Body)this.literal("\n}")), this.rule().add(new Condition[]{this.condition("type", "parameter & list"), this.condition("trigger", "signature")}).add((Token.Body)this.literal("java.util.List<")).add((Token.Body)this.mark("type", new String[0])).add((Token.Body)this.literal("> ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "signature")}).add((Token.Body)this.mark("type", new String[0])).add((Token.Body)this.literal(" ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "name")}).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})), this.rule().add(new Condition[]{this.condition("type", "parameter & objectData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.setText(new Gson().toJson(")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("));")), this.rule().add(new Condition[]{this.condition("type", "parameter & fileData"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.writeBytes(toByteArray(")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(".content()));")), this.rule().add(new Condition[]{this.condition("type", "parameter & list"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.setStringProperty(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", new Gson().toJson(")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("));")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("message.set")).add((Token.Body)this.mark("type", new String[]{"format"})).add((Token.Body)this.literal("Property(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(");")), this.rule().add(new Condition[]{this.condition("type", "reply"), this.condition("trigger", "type")}).add((Token.Body)this.literal("Text")), this.rule().add(new Condition[]{this.condition("type", "reply & fileData"), this.condition("trigger", "type")}).add((Token.Body)this.literal("Bytes")), this.rule().add(new Condition[]{this.condition("type", "reply & list"), this.condition("trigger", "return")}).add((Token.Body)this.literal("List<")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(">")), this.rule().add(new Condition[]{this.condition("type", "reply"), this.condition("trigger", "return")}).add((Token.Body)this.mark("value", new String[0])), this.rule().add(new Condition[]{this.condition("attribute", "Integer"), this.condition("trigger", "format")}).add((Token.Body)this.literal("Int")), this.rule().add(new Condition[]{this.condition("type", "reply & fileData"), this.condition("trigger", "reply")}).add((Token.Body)this.literal("byte[] bytes = new byte[(int) ((BytesMessage) message).getBodyLength()];\n((BytesMessage) message).readBytes(bytes);\ncallback(new io.intino.alexandria.Resource(\"file\",\"\", new java.io.ByteArrayInputStream(bytes)));")), this.rule().add(new Condition[]{this.condition("type", "reply & list"), this.condition("trigger", "reply")}).add((Token.Body)this.literal("java.lang.reflect.Type listType = new com.google.gson.reflect.TypeToken<java.util.ArrayList<")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(">>(){}.getType();\ncallback(new Gson().fromJson(((TextMessage) message).getText(), listType));")), this.rule().add(new Condition[]{this.condition("type", "reply"), this.condition("trigger", "reply")}).add((Token.Body)this.literal("callback(new Gson().fromJson(((TextMessage) message).getText(), ")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(".class));")), this.rule().add(new Condition[]{this.condition("type", "schemaImport")}).add((Token.Body)this.literal("import ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".schemas.*;"))});
        return this;
    }
}

