/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.resource;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.AccessibleDisplayActionRenderer;
import io.intino.konos.builder.codegeneration.action.UIActionRenderer;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.resource.ResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.accessible.AccessibleDisplay;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ResourceRenderer
extends UIRenderer {
    private final Project project;
    private final File src;
    private final File gen;
    private final List<AbstractUIService.Resource> resourceList;
    private final Map<String, String> classes;
    private final List<AccessibleDisplay> accessibleDisplays;

    public ResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        super(boxName, packageName);
        this.project = project;
        this.src = src;
        this.gen = gen;
        this.resourceList = graph.core$().find(AbstractUIService.Resource.class);
        this.accessibleDisplays = graph.accessibleDisplayList();
        this.classes = classes;
    }

    public void execute() {
        this.resourceList.forEach(this::processResource);
        this.accessibleDisplays.forEach(this::processDisplay);
    }

    private void processDisplay(AccessibleDisplay display) {
        Frame frame = this.buildFrame().addSlot("name", new String[]{display.name$()}).addTypes(new String[]{"resource", ((Object)((Object)display)).getClass().getSimpleName()});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(display));
        Commons.writeFrame(new File(this.gen, "resources"), StringHelper.snakeCaseToCamelCase((String)(display.name$() + "ProxyResource")), this.template().format((Object)frame));
        this.createCorrespondingAction(display);
    }

    private void processResource(AbstractUIService.Resource resource) {
        UIService uiService = (UIService)resource.core$().ownerAs(UIService.class);
        Frame frame = this.buildFrame().addTypes(new String[]{"resource"}).addSlot("name", new String[]{resource.name$()}).addSlot("parameter", (AbstractFrame[])this.parameters(resource));
        if (resource.isEditorPage()) {
            frame.addSlot("editor", new String[]{"Editor"});
        }
        if (uiService.googleApiKey() != null) {
            frame.addSlot("googleApiKey", new AbstractFrame[]{Formatters.customize("googleApiKey", uiService.googleApiKey())});
        }
        if (resource.isConfidential()) {
            frame.addSlot("confidential", new String[]{""});
        }
        Commons.writeFrame(new File(this.gen, "resources"), StringHelper.snakeCaseToCamelCase((String)(resource.name$() + "Resource")), this.template().format((Object)frame));
        this.createCorrespondingAction(resource);
    }

    @Override
    protected Frame buildFrame() {
        return new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("package", new String[]{this.packageName});
    }

    private void createCorrespondingAction(AbstractUIService.Resource resource) {
        new UIActionRenderer(this.project, resource, this.src, this.gen, this.packageName, this.box, this.classes).execute();
    }

    private void createCorrespondingAction(AccessibleDisplay display) {
        new AccessibleDisplayActionRenderer(this.project, display, this.src, this.packageName, this.box, this.classes).execute();
    }

    private Template template() {
        Template template = ResourceTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }

    private Frame[] parameters(AbstractUIService.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        return (Frame[])parameters.stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter})).toArray(Frame[]::new);
    }

    private Frame[] parameters(AccessibleDisplay display) {
        return (Frame[])display.parameters().stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter})).toArray(Frame[]::new);
    }
}

