/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class AbstractBoxTemplate
extends Template {
    protected AbstractBoxTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new AbstractBoxTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "box")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(";\n\nimport java.util.LinkedHashMap;\nimport java.util.Map;\nimport java.util.UUID;")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[0])).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("import java.util.HashMap;")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("import java.util.Map;")).add((Token.Body)this.literal("\n"))).add((Token.Body)this.literal("\nimport io.intino.alexandria.logger.Logger;\nimport java.util.logging.ConsoleHandler;\nimport java.util.logging.Level;\n")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.mark("hasREST", new String[0])).add((Token.Body)this.literal("import io.intino.alexandria.rest.AlexandriaSpark;"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("import io.intino.alexandria.ui.displays.Soul;"))).add((Token.Body)this.literal("\n\npublic abstract class AbstractBox extends ")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"uiBox"})).or(this.expression().add((Token.Body)this.literal("io.intino.alexandria.core.Box")))).add((Token.Body)this.literal(" {\n\tprotected ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration configuration;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("service", new String[]{"field"}).multiple("\n"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("dataLake", new String[]{"field"}).multiple("\n"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("task", new String[]{"field"}))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("    ")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("protected Map<String, Soul> uiSouls = new java.util.HashMap<>();"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("    ")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private java.util.List<io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new java.util.ArrayList<>();"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private io.intino.alexandria.ui.services.AuthService authService;"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private io.intino.alexandria.ui.services.EditorService editorService;"))).add((Token.Body)this.literal("\n\n\tpublic AbstractBox(String[] args) {\n\t\tthis(new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration(args));\n\t}\n\t\n\tpublic AbstractBox(")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration configuration) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("owner = new ")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box(configuration);"))).add((Token.Body)this.literal("\n\t\tthis.configuration = configuration;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\tinitJavaLogger();")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("service", new String[]{"setup"}).multiple("\n"))).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("datalake", new String[]{"setup"})).add((Token.Body)this.literal("\n\t}\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Configuration configuration() {\n\t\treturn configuration;\n\t}\n\n\t@Override\n\tpublic io.intino.alexandria.core.Box put(Object o) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasParent", new String[0])).add((Token.Body)this.literal("owner.put(o);"))).add((Token.Body)this.literal("\n\t\treturn this;\n\t}\n\n\tpublic io.intino.alexandria.core.Box open() {\n\t\tif (owner != null) owner.open();\n\t\tinitUI();\n\t\tinitRESTServices();\n\t\tinitJMXServices();\n\t\tinitJMSServices();\n\t\tinitDatalake();\n\t\tinitTasks();\n\t\tinitSlackBots();\n\t\treturn this;\n\t}\n\n\tpublic void close() {\n\t\tif(owner != null) owner.close();\n\t\t")).add((Token.Body)this.mark("spark", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("service", new String[]{"quit"}).multiple("\n")).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("dataLake", new String[]{"quit"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"registerSoul"})).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t"))).add((Token.Body)this.expression().add((Token.Body)this.mark("service", new String[]{"getter"}).multiple("\n\n"))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"authService"}))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"editorService"}))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.mark("dataLake", new String[]{"getter"}).multiple("\n\n")).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.mark("task", new String[]{"getter"}).multiple("\n\n")).add((Token.Body)this.literal("\n\n\tprivate void initRESTServices() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"rest"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initJMSServices() {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("jms", new String[0])).add((Token.Body)this.literal("javax.jms.Connection connection;"))).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("service", new String[]{"jms"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initJMXServices() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"jmx"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initSlackBots() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"slack"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initUI() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"ui"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initDatalake() {\n\t\t")).add((Token.Body)this.mark("dataLake", new String[]{"init"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("datalake", new String[]{"hide"})).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\tprivate io.intino.ness.core.Datalake datalakeFrom(String nessUrl, String nessUser, String nessPassword, String clientId) {")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\tif (nessUrl.startsWith(\"file://\")) return new io.intino.alexandria.nessaccessor.local.LocalDatalake(new java.io.File(nessUrl.replace(\"file://\", \"\")));")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\treturn new io.intino.alexandria.nessaccessor.tcp.TCPDatalake(nessUrl, nessUser, nessPassword, clientId);")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t}")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t"))).add((Token.Body)this.literal("\n\tprivate void initTasks() {\n\t\t")).add((Token.Body)this.mark("task", new String[]{"init"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initJavaLogger() {\n\t\tfinal java.util.logging.Logger Logger = java.util.logging.Logger.getGlobal();\n\t\tfinal ConsoleHandler handler = new ConsoleHandler();\n\t\thandler.setLevel(Level.INFO);\n\t\thandler.setFormatter(new io.intino.alexandria.logger.Formatter());\n\t\tLogger.setUseParentHandlers(false);\n\t\tLogger.addHandler(handler);\n\t}\n\n\tprivate static java.net.URL url(String url) {\n\t\ttry {\n\t\treturn new java.net.URL(url);\n\t\t} catch (java.net.MalformedURLException e) {\n\t\t\treturn null;\n\t\t}\n\t}\n}")), this.rule().add(new Condition[]{this.condition("trigger", "uiBox")}).add((Token.Body)this.literal("io.intino.alexandria.ui.AlexandriaUiBox")), this.rule().add(new Condition[]{this.condition("type", "service & ui"), this.condition("trigger", "setup")}).add((Token.Body)this.literal("this.authService = ")).add((Token.Body)this.expression().add((Token.Body)this.literal("this.authService(")).add((Token.Body)this.mark("authentication", new String[0])).add((Token.Body)this.literal(")")).or(this.expression().add((Token.Body)this.literal("null")))).add((Token.Body)this.literal(";\nthis.editorService = ")).add((Token.Body)this.expression().add((Token.Body)this.literal("this.editorService(")).add((Token.Body)this.mark("edition", new String[0])).add((Token.Body)this.literal(")")).or(this.expression().add((Token.Body)this.literal("null")))).add((Token.Body)this.literal(";\n")).add((Token.Body)this.expression().add((Token.Body)this.literal("if(")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(" != null && !")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(".isEmpty())"))).add((Token.Body)this.expression().add((Token.Body)this.literal("io.intino.alexandria.rest.AlexandriaSparkBuilder.setup(Integer.parseInt(")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal("), \"www/\")"))).add((Token.Body)this.literal(";\nio.intino.alexandria.rest.AlexandriaSparkBuilder.setUI(true);\nio.intino.alexandria.rest.AlexandriaSparkBuilder.addParameters(this.authService, this.editorService);")), this.rule().add(new Condition[]{this.condition("type", "service & rest"), this.condition("trigger", "setup")}).add((Token.Body)this.literal("io.intino.alexandria.rest.AlexandriaSparkBuilder.setup(Integer.parseInt(")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal("), \"www/\");")), this.rule().add(new Condition[]{this.condition("type", "datalake"), this.condition("trigger", "setup")}).add((Token.Body)this.literal("this.nessAccessor = new io.intino.alexandria.nessaccessor.NessAccessor(datalakeFrom(")).add((Token.Body)this.mark("parameter", new String[0]).multiple(", ")).add((Token.Body)this.literal("));")), this.rule().add(new Condition[]{this.condition("type", "service & jmx"), this.condition("trigger", "jmx")}).add((Token.Body)this.literal("this.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstLowerCase"})).add((Token.Body)this.literal(" = new JMX")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("().init(((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this));\nLogger.info(\"JMX service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "slack")}).add((Token.Body)this.literal("if (")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(" == null || ")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(".isEmpty()) return;\nthis.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstLowerCase"})).add((Token.Body)this.literal(" = new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("SlackBot((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this, ")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(");\nLogger.info(\"Slack service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & rest"), this.condition("trigger", "rest")}).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Service.setup(io.intino.alexandria.rest.AlexandriaSparkBuilder.instance(), (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this).start();\nLogger.info(\"REST service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & ui"), this.condition("trigger", "ui")}).add((Token.Body)this.expression().add((Token.Body)this.literal("if (")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(" == null || !io.intino.alexandria.rest.AlexandriaSparkBuilder.isUI()) return;"))).add((Token.Body)this.literal("\nio.intino.alexandria.ui.UIAlexandriaSpark sparkInstance = (io.intino.alexandria.ui.UIAlexandriaSpark) io.intino.alexandria.rest.AlexandriaSparkBuilder.instance();\n")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Service.init(sparkInstance, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\nio.intino.alexandria.ui.UiElementsService.initDisplays(sparkInstance);\n")).add((Token.Body)this.mark("use", new String[0]).multiple("\n")).add((Token.Body)this.literal("\nsparkInstance.start();\nLogger.info(\"UI ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("trigger", "use")}).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(".initDisplays(sparkInstance);")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "jms")}).add((Token.Body)this.literal("try {\n\tconnection = new org.apache.activemq.ActiveMQConnectionFactory(")).add((Token.Body)this.mark("parameter", new String[0]).multiple(", ")).add((Token.Body)this.literal(").createConnection();\n\tjava.lang.Thread thread = new java.lang.Thread(() -> {\n\t\ttry {\n\t\t\tconnection.start();\n\t\t\tthis.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service(connection, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\n\t\t\tLogger.info(\"JMS service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");\n\t\t} catch (javax.jms.JMSException e) {\n\t\t\tLogger.error(e.getMessage());\n\t\t}\n\t}, \"jms init\");\n\tthread.start();\n\tthread.join(10000);\n} catch (javax.jms.JMSException | InterruptedException e) {\n\tLogger.error(e.getMessage());\n}")), this.rule().add(new Condition[]{this.condition("type", "dataLake & requireConnection"), this.condition("trigger", "init")}).add((Token.Body)this.literal("this.nessAccessor.connection().connect(\"")).add((Token.Body)this.mark("mode", new String[0])).add((Token.Body)this.literal("\");\n")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".datalake.Datalake.registerTanks((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\nregisterFeeders();\n")).add((Token.Body)this.mark("nessOperations", new String[0])).add((Token.Body)this.literal("\nif (nessAccessor.connection() instanceof io.intino.alexandria.nessaccessor.tcp.TCPDatalake.Connection && ((io.intino.alexandria.nessaccessor.tcp.TCPDatalake.Connection) nessAccessor.connection()).session() != null)\n\tLogger.info(\"Ness connection: started!\");")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "init")}).add((Token.Body)this.literal("java.lang.Thread thread = new java.lang.Thread(() -> {\n\tthis.nessAccessor.connection().connect(\"")).add((Token.Body)this.mark("mode", new String[0])).add((Token.Body)this.literal("\");\n\t")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".datalake.Datalake.registerTanks((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\n\tregisterFeeders();\n\t")).add((Token.Body)this.mark("nessOperations", new String[0])).add((Token.Body)this.literal("\n\tif (nessAccessor.connection() instanceof io.intino.alexandria.nessaccessor.tcp.TCPDatalake.Connection && ((io.intino.alexandria.nessaccessor.tcp.TCPDatalake.Connection) nessAccessor.connection()).session() != null)\n\t\tLogger.info(\"Ness connection: started!\");\n}, \"ness accessor init\");\ntry {\n\tthread.start();\n\tthread.join(10000);\n} catch (InterruptedException e) {\n\tLogger.error(e.getMessage());\n}")), this.rule().add(new Condition[]{this.condition("trigger", "nessOperations")}).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".datalake.NessOperations.init((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "parameter")}).add((Token.Body)this.literal("configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "authentication")}).add((Token.Body)this.literal("url(configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\"))")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "edition")}).add((Token.Body)this.literal("url(configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\"))")), this.rule().add(new Condition[]{this.condition("trigger", "parameter")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\"")), this.rule().add(new Condition[]{this.condition("trigger", "authentication")}).add((Token.Body)this.literal("url(\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("trigger", "edition")}).add((Token.Body)this.literal("url(\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("attribute", "Transacted"), this.condition("trigger", "mode")}).add((Token.Body)this.literal("Transacted")), this.rule().add(new Condition[]{this.condition("trigger", "mode")}), this.rule().add(new Condition[]{this.condition("type", "service & jmx"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.alexandria.jmx.JMXServer ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.alexandria.slack.Bot ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.alexandria.scheduler.AlexandriaScheduler scheduler = new io.intino.alexandria.scheduler.AlexandriaScheduler();")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.alexandria.nessaccessor.NessAccessor nessAccessor;")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal("() {\n\treturn ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";\n}")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public io.intino.alexandria.nessaccessor.NessAccessor nessAccessor() {\n\treturn this.nessAccessor;\n}\n\npublic io.intino.alexandria.core.Feeders feeders() {\n\treturn io.intino.alexandria.core.Feeders.get();\n}\n\npublic void registerFeeders() {\n\t")).add((Token.Body)this.mark("feeder", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n}")), this.rule().add(new Condition[]{this.condition("trigger", "feeder")}).add((Token.Body)this.literal("io.intino.alexandria.core.Feeders.get().register(new ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".datalake.feeders.")).add((Token.Body)this.mark("name", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("((")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box)this));")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("SlackBot ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal("() {\n\treturn (")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("SlackBot) ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";\n}")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("trigger", "getter")}), this.rule().add(new Condition[]{this.condition("trigger", "spark")}).add((Token.Body)this.literal("io.intino.alexandria.rest.AlexandriaSparkBuilder.instance().stop();")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("type", "jms"), this.condition("trigger", "quit")}).add((Token.Body)this.literal("if (")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(" != null) ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(".closeSession();")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "quit")}).add((Token.Body)this.literal("if (nessAccessor != null) nessAccessor.connection().disconnect();")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("trigger", "quit")}), this.rule().add(new Condition[]{this.condition("type", "service")}), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "init")}).add((Token.Body)this.literal("Tasks.init(this.scheduler, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);")), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public io.intino.alexandria.scheduler.AlexandriaScheduler scheduler() {\n\treturn this.scheduler;\n}")), this.rule().add(new Condition[]{this.condition("trigger", "authservice")}).add((Token.Body)this.literal("protected abstract io.intino.alexandria.ui.services.AuthService authService(java.net.URL authServiceUrl);")), this.rule().add(new Condition[]{this.condition("trigger", "editorService")}).add((Token.Body)this.literal("protected abstract io.intino.alexandria.ui.services.EditorService editorService(java.net.URL editorServiceUrl);\n\npublic io.intino.alexandria.ui.services.EditorService editorService() {\n\treturn this.editorService;\n}")), this.rule().add(new Condition[]{this.condition("trigger", "registerSoul")}).add((Token.Body)this.literal("public java.util.List<Soul> souls() {\n\treturn new java.util.ArrayList<>(uiSouls.values());\n}\n\n\tpublic java.util.Optional<Soul> soul(String clientId) {\n\t\treturn java.util.Optional.ofNullable(uiSouls.get(clientId));\n\t}\n\n\tpublic void registerSoul(String clientId, Soul soul) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).registerSoul(clientId, soul);"))).add((Token.Body)this.literal("\n\t\tuiSouls.put(clientId, soul);\n\t}\n\n\tpublic void unRegisterSoul(String clientId) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).unRegisterSoul(clientId);"))).add((Token.Body)this.literal("\n\t\tuiSouls.remove(clientId);\n\t\tif (uiSouls.size() <= 0) notifySoulsClosed();\n\t}\n\n\tpublic void onSoulsClosed(io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed listener) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).onSoulsClosed(listener);"))).add((Token.Body)this.literal("\n\t\tthis.soulsClosedListeners.add(listener);\n\t}\n\n\tprivate void notifySoulsClosed() {\n\t\tsoulsClosedListeners.forEach(l -> l.accept());\n\t}")), this.rule().add(new Condition[]{this.condition("trigger", "import")}), this.rule().add(new Condition[]{this.condition("trigger", "parentInit")}), this.rule().add(new Condition[]{this.condition("trigger", "hide")})});
        return this;
    }
}

