/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import com.intellij.openapi.module.Module;
import com.intellij.util.io.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.accessor.ui.ArtifactTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.ResourceTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.WidgetsTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldFrameBuilder;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldLayoutTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.mold.MoldTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.DialogWidgetTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetNotifierTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetRequesterTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetRoutesTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.widget.WidgetTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.addressable.display.AddressableRequest;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.file.FileURLConnection;

public class UIAccessorRenderer {
    private static final String SRC_DIRECTORY = "src";
    private static final String ARTIFACT_LEGIO = "artifact.legio";
    private Module appModule;
    private final File genDirectory;
    private final UIService service;
    private String parent;

    UIAccessorRenderer(Module appModule, Module webModule, UIService service, String parent) {
        this.appModule = appModule;
        this.genDirectory = this.rootDirectory(webModule);
        this.service = service;
        this.parent = parent;
    }

    public UIAccessorRenderer(File rootDirectory, UIService service) {
        this.genDirectory = rootDirectory;
        this.service = service;
    }

    boolean createConfigurationFile() {
        Configuration configuration = TaraUtil.configurationOf((Module)this.appModule);
        Frame frame = new Frame(new String[0]);
        frame.addTypes(new String[]{"artifact", "legio"});
        frame.addSlot("groupID", new String[]{configuration.groupId()});
        frame.addSlot("artifactID", new String[]{configuration.artifactId()});
        frame.addSlot("version", new String[]{configuration.version()});
        Map<String, List<String>> repositories = this.reduce(configuration.releaseRepositories());
        for (String id : repositories.keySet()) {
            Frame repoFrame = new Frame(new String[0]).addTypes(new String[]{"repository", "release"}).addSlot("id", new String[]{id});
            for (String url : repositories.get(id)) {
                repoFrame.addSlot("url", new String[]{url});
            }
            frame.addSlot("repository", new AbstractFrame[]{repoFrame});
        }
        File file = new File(this.genDirectory, ARTIFACT_LEGIO);
        if (!file.exists()) {
            Commons.write(file.toPath(), ArtifactTemplate.create().format((Object)frame));
            return true;
        }
        return false;
    }

    private Map<String, List<String>> reduce(Map<String, String> map) {
        HashMap<String, List<String>> reduced = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!reduced.containsKey(entry.getValue())) {
                reduced.put(entry.getValue(), new ArrayList());
            }
            ((List)reduced.get(entry.getValue())).add(entry.getKey());
        }
        return reduced;
    }

    public void execute() {
        try {
            this.createStaticFiles();
            this.createWidgets();
            this.createResources();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createResources() {
        for (AbstractUIService.Resource resource : this.service.resourceList()) {
            Path resourcePath = new File(this.genDirectory, SRC_DIRECTORY + File.separator + resource.name$() + ".html").toPath();
            if (Files.exists(resourcePath, new LinkOption[0])) continue;
            Commons.write(resourcePath, ResourceTemplate.create().format((Object)this.resourceFrame(resource)));
        }
    }

    private Frame resourceFrame(AbstractUIService.Resource resource) {
        Component uses = KonosGraph.componentFor(resource);
        Frame result = new Frame(new String[0]).addTypes(new String[]{"resource"}).addSlot("uses", new String[]{uses.name$()}).addSlot("name", new String[]{resource.name$()});
        result.addSlot("polymer", new AbstractFrame[]{this.polymerFrame(resource)});
        return result;
    }

    private Frame polymerFrame(AbstractUIService.Resource resource) {
        Frame result = new Frame(new String[]{"polymer"});
        if (resource.isEditorPage()) {
            result.addTypes(new String[]{"editor"});
        }
        return result;
    }

    private void createWidgets() {
        Frame widgets = new Frame(new String[0]).addTypes(new String[]{"widgets"});
        for (Component component : KonosGraph.componentsOf(this.service)) {
            if (component.i$(Mold.class)) {
                this.createMold((Mold)component.a$(Mold.class));
            }
            if (component.i$(Display.class) && !component.i$(Mold.class)) {
                this.createDisplay((Display)component.a$(Display.class));
            }
            if (component.i$(Dialog.class)) {
                this.createDialog((Dialog)component.a$(Dialog.class));
            }
            widgets.addSlot("widget", new String[]{component.name$()});
        }
        Commons.write(new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + "widgets.html").toPath(), Formatters.customize(WidgetsTemplate.create()).format((Object)widgets));
    }

    private void createDisplay(Display component) {
        this.createNotifier(component);
        this.createRequester(component);
        this.createDisplayWidget(component);
    }

    private void createMold(Mold mold) {
        Frame frame = this.frameOf(mold);
        this.createMoldLayout(mold.name$(), frame);
        this.createMold(mold.name$(), frame);
    }

    private Frame frameOf(Mold mold) {
        return new MoldFrameBuilder(this.service, mold).build();
    }

    private void createMoldLayout(String name, Frame frame) {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + name.toLowerCase() + File.separator + Formatters.camelCaseToSnakeCase().format((Object)name) + "-layout.html");
        file.getParentFile().mkdirs();
        Commons.write(file.toPath(), Formatters.customize(MoldLayoutTemplate.create()).format((Object)frame));
    }

    private void createMold(String name, Frame frame) {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + Formatters.camelCaseToSnakeCase().format((Object)name) + ".html");
        if (!file.exists()) {
            Commons.write(file.toPath(), Formatters.customize(MoldTemplate.create()).format((Object)frame));
        }
    }

    private void createDisplayWidget(Display display) {
        List<Display.Request> requests;
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.isAccessible()) {
            frame.addTypes(new String[]{"accessible"});
        }
        if (display.parentDisplay() != null) {
            frame.addSlot("parent", new AbstractFrame[]{new Frame(new String[0]).addSlot("value", new String[]{display.parentDisplay()}).addSlot("dsl", new String[]{this.parent.substring(this.parent.lastIndexOf(".") + 1)})});
        }
        boolean prototype = this.isPrototype(display);
        String type = this.typeOf(display);
        if (prototype) {
            frame.addSlot("prototype", new AbstractFrame[]{new Frame(new String[]{"prototype"}).addSlot("widget", new String[]{display.name$()}).addSlot("type", new String[]{type})});
        }
        if (!prototype) {
            frame.addSlot("attached", new AbstractFrame[]{new Frame(new String[]{"display"}).addSlot("widget", new String[]{display.name$()}).addSlot("type", new String[]{type})});
        }
        if (prototype) {
            frame.addSlot("imports", new AbstractFrame[]{new Frame(new String[0]).addSlot("type", new String[]{type})});
            frame.addSlot("type", new String[]{type});
        }
        if (!(requests = display.requestList().stream().filter(Display.Request::isAddressable).collect(Collectors.toList())).isEmpty()) {
            frame.addSlot("routes", new AbstractFrame[]{new Frame(new String[]{"routes"}).addSlot("name", new String[]{display.name$()})});
            this.writeWidgetRoutes(display, requests);
        }
        this.writeWidget(display, frame);
    }

    private String typeOf(Display display) {
        String type = ((Object)((Object)display)).getClass().getSimpleName();
        if (display.i$(Panel.class) && ((Panel)display.a$(Panel.class)).isDesktop()) {
            return "desktop";
        }
        if (type.equalsIgnoreCase("temporalCatalog")) {
            return "temporal" + ((TemporalCatalog)display.a$(TemporalCatalog.class)).type().name() + "Catalog";
        }
        return type;
    }

    private void writeWidgetRoutes(Display display, List<Display.Request> requests) {
        Frame frame = new Frame(new String[]{"routes"}).addSlot("name", new String[]{display.name$()});
        for (Display.Request request : requests) {
            frame.addSlot("route", new AbstractFrame[]{this.routeFrame(request)});
        }
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + "-routes.html");
        Commons.write(file.toPath(), Formatters.customize(WidgetRoutesTemplate.create()).format((Object)frame));
    }

    private Frame routeFrame(Display.Request r) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"route"}).addSlot("request", new String[]{r.name$()});
        if (r.isType()) {
            frame.addTypes(new String[]{"parameter"});
        }
        if (r.isAddressable()) {
            AddressableRequest addressableRequest = r.asAddressable();
            if (addressableRequest.listenForChanges()) {
                frame.addTypes(new String[]{"listenForChanges"});
            }
            frame.addSlot("routePath", new AbstractFrame[]{this.routePathFrame(r)});
            frame.addSlot("value", new String[]{addressableRequest.addressableResource().path()});
        }
        return frame;
    }

    private Frame routePathFrame(Display.Request r) {
        Frame frame = new Frame(new String[]{"routePath"});
        AddressableRequest addressable = r.asAddressable();
        if (addressable.encoded()) {
            frame.addTypes(new String[]{"encoded"});
        }
        frame.addSlot("value", new String[]{addressable.addressableResource().path()});
        return frame;
    }

    private void writeWidget(Display display, Frame frame) {
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + ".html");
        if (!file.exists()) {
            Commons.write(file.toPath(), Formatters.customize(WidgetTemplate.create()).format((Object)frame));
        }
        if (display.isAccessible()) {
            frame.addTypes(new String[]{"accessible"});
            file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)display.name$()).toLowerCase() + "-proxy.html");
            Commons.write(file.toPath(), Formatters.customize(WidgetTemplate.create()).format((Object)frame));
        }
    }

    private boolean isPrototype(Display display) {
        return !((Object)((Object)display)).getClass().getSimpleName().equals(Display.class.getSimpleName());
    }

    private void createDialog(Dialog dialog) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()});
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + StringHelper.camelCaseToSnakeCase((String)dialog.name$()).toLowerCase() + ".html");
        if (!file.exists()) {
            Commons.write(file.toPath(), Formatters.customize(DialogWidgetTemplate.create()).format((Object)frame));
        }
    }

    private void createRequester(Display display) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("request", (AbstractFrame[])((Frame[])display.requestList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + "requester.js");
        file.getParentFile().mkdirs();
        Commons.write(file.toPath(), Formatters.customize(WidgetRequesterTemplate.create()).format((Object)frame));
        if (display.isAccessible()) {
            frame.addTypes(new String[]{"accessible"});
            file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + "proxy" + File.separator + "requester.js");
            file.getParentFile().mkdirs();
            Commons.write(file.toPath(), Formatters.customize(WidgetRequesterTemplate.create()).format((Object)frame));
        }
    }

    private void createNotifier(Display display) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"widget"}).addSlot("name", new String[]{display.name$()}).addSlot("notification", (AbstractFrame[])((Frame[])display.notificationList().stream().map(this::frameOf).toArray(Frame[]::new)));
        File file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + File.separator + "notifier-listener.js");
        file.getParentFile().mkdirs();
        Commons.write(file.toPath(), Formatters.customize(WidgetNotifierTemplate.create()).format((Object)frame));
        if (display.isAccessible()) {
            frame.addTypes(new String[]{"accessible"});
            file = new File(this.genDirectory, SRC_DIRECTORY + File.separator + "widgets" + File.separator + display.name$().toLowerCase() + "proxy" + File.separator + "notifier-listener.js");
            file.getParentFile().mkdirs();
            Commons.write(file.toPath(), Formatters.customize(WidgetNotifierTemplate.create()).format((Object)frame));
        }
    }

    private Frame frameOf(Display.Notification n) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"notification"}).addSlot("name", new String[]{n.name$()}).addSlot("to", new String[]{n.to().name()});
        if (n.asType() != null) {
            frame.addSlot("parameter", new String[]{""});
        }
        return frame;
    }

    private Frame frameOf(Display.Request r) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"request"}).addSlot("name", new String[]{r.name$()}).addSlot("widget", new String[]{r.core$().owner().name()});
        if (r.isType()) {
            frame.addTypes(new String[]{"parameter"});
        }
        if (r.isAddressable()) {
            frame.addTypes(new String[]{"addressable"});
        }
        frame.addSlot("method", new String[]{r.responseType().name()});
        return frame;
    }

    private void createStaticFiles() throws IOException {
        File src = new File(this.genDirectory, SRC_DIRECTORY);
        src.mkdirs();
        File file = new File(src, "ui.zip");
        this.copyResourcesRecursively(this.getClass().getResource("/ui/ui.zip"), file);
        ZipUtil.extract((File)file, (File)src, null, (boolean)false);
        file.delete();
        new File(src, "images").mkdirs();
        new File(src, "widgets").mkdirs();
    }

    private File rootDirectory(Module webModule) {
        return new File(webModule.getModuleFilePath()).getParentFile();
    }

    private void copyResourcesRecursively(URL originUrl, File destination) {
        block4: {
            try {
                URLConnection urlConnection = originUrl.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
                    break block4;
                }
                if (urlConnection instanceof FileURLConnection) {
                    FileUtils.copyFile((File)new File(originUrl.getPath()), (File)destination);
                    break block4;
                }
                throw new Exception("URLConnection[" + urlConnection.getClass().getSimpleName() + "] is not a recognized/implemented connection type.");
            }
            catch (Exception e) {
                LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            entryInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entryInputStream.close();
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }
}

