/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.jms;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JMSService
extends Layer
implements Terminal {
    protected String url;
    protected String user;
    protected String password;
    protected String clientId;
    protected SubscriptionModel subscriptionModel;
    protected List<Request> requestList = new ArrayList<Request>();
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected List<Authentication> authenticationList = new ArrayList<Authentication>();
    protected List<CredentialSecured> credentialSecuredList = new ArrayList<CredentialSecured>();
    protected List<CertificateSecured> certificateSecuredList = new ArrayList<CertificateSecured>();
    protected Service _service;

    public JMSService(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String clientId() {
        return this.clientId;
    }

    public SubscriptionModel subscriptionModel() {
        return this.subscriptionModel;
    }

    public JMSService url(String value) {
        this.url = value;
        return this;
    }

    public JMSService user(String value) {
        this.user = value;
        return this;
    }

    public JMSService password(String value) {
        this.password = value;
        return this;
    }

    public JMSService clientId(String value) {
        this.clientId = value;
        return this;
    }

    public JMSService subscriptionModel(SubscriptionModel value) {
        this.subscriptionModel = value;
        return this;
    }

    public List<Request> requestList() {
        return Collections.unmodifiableList(this.requestList);
    }

    public Request request(int index) {
        return this.requestList.get(index);
    }

    public List<Request> requestList(Predicate<Request> predicate) {
        return this.requestList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Authentication> authenticationList() {
        return Collections.unmodifiableList(this.authenticationList);
    }

    public Authentication authentication(int index) {
        return this.authenticationList.get(index);
    }

    public List<Authentication> authenticationList(Predicate<Authentication> predicate) {
        return this.authenticationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<CredentialSecured> credentialSecuredList() {
        return Collections.unmodifiableList(this.credentialSecuredList);
    }

    public CredentialSecured credentialSecured(int index) {
        return this.credentialSecuredList.get(index);
    }

    public List<CredentialSecured> credentialSecuredList(Predicate<CredentialSecured> predicate) {
        return this.credentialSecuredList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<CertificateSecured> certificateSecuredList() {
        return Collections.unmodifiableList(this.certificateSecuredList);
    }

    public CertificateSecured certificateSecured(int index) {
        return this.certificateSecuredList.get(index);
    }

    public List<CertificateSecured> certificateSecuredList(Predicate<CertificateSecured> predicate) {
        return this.certificateSecuredList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        new ArrayList<Authentication>(this.authenticationList).forEach(c -> components.add(c.core$()));
        new ArrayList<CredentialSecured>(this.credentialSecuredList).forEach(c -> components.add(c.core$()));
        new ArrayList<CertificateSecured>(this.certificateSecuredList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
        map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
        map.put("clientId", new ArrayList<String>(Collections.singletonList(this.clientId)));
        map.put("subscriptionModel", new ArrayList<SubscriptionModel>(Collections.singletonList(this.subscriptionModel)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("JMS#Service$Request")) {
            this.requestList.add((Request)node.as(Request.class));
        }
        if (node.is("JMS#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
        if (node.is("JMS#Service$Authentication")) {
            this.authenticationList.add((Authentication)node.as(Authentication.class));
        }
        if (node.is("JMS#Service$CredentialSecured")) {
            this.credentialSecuredList.add((CredentialSecured)node.as(CredentialSecured.class));
        }
        if (node.is("JMS#Service$CertificateSecured")) {
            this.certificateSecuredList.add((CertificateSecured)node.as(CertificateSecured.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("JMS#Service$Request")) {
            this.requestList.remove(node.as(Request.class));
        }
        if (node.is("JMS#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
        if (node.is("JMS#Service$Authentication")) {
            this.authenticationList.remove(node.as(Authentication.class));
        }
        if (node.is("JMS#Service$CredentialSecured")) {
            this.credentialSecuredList.remove(node.as(CredentialSecured.class));
        }
        if (node.is("JMS#Service$CertificateSecured")) {
            this.certificateSecuredList.remove(node.as(CertificateSecured.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("user")) {
            this.user = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("password")) {
            this.password = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("clientId")) {
            this.clientId = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("subscriptionModel")) {
            this.subscriptionModel = (SubscriptionModel)((Object)WordLoader.load(values, SubscriptionModel.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("user")) {
            this.user = (String)values.get(0);
        } else if (name.equalsIgnoreCase("password")) {
            this.password = (String)values.get(0);
        } else if (name.equalsIgnoreCase("clientId")) {
            this.clientId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("subscriptionModel")) {
            this.subscriptionModel = (SubscriptionModel)((Object)values.get(0));
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class CertificateSecured
    extends Authentication
    implements Terminal {
        protected String certificate;

        public CertificateSecured(Node node) {
            super(node);
        }

        public String certificate() {
            return this.certificate;
        }

        public CertificateSecured certificate(String value) {
            this.certificate = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("certificate", new ArrayList<String>(Collections.singletonList(this.certificate)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("certificate")) {
                this.certificate = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("certificate")) {
                this.certificate = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class CredentialSecured
    extends Authentication
    implements Terminal {
        protected String username;
        protected String password;

        public CredentialSecured(Node node) {
            super(node);
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public CredentialSecured username(String value) {
            this.username = value;
            return this;
        }

        public CredentialSecured password(String value) {
            this.password = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("username", new ArrayList<String>(Collections.singletonList(this.username)));
            map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("username")) {
                this.username = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("username")) {
                this.username = (String)values.get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class Authentication
    extends Layer
    implements Terminal {
        public Authentication(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Notification
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();

        public Notification(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public Notification path(String value) {
            this.path = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Notification.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Notification.this.core$().graph().concept(Parameter.class).createNode(this.name, Notification.this.core$()).as(Parameter.class);
                return newElement;
            }

            public RESTService.Resource.Parameter parameter(RESTService.Resource.Parameter.In in) {
                RESTService.Resource.Parameter newElement = (RESTService.Resource.Parameter)Notification.this.core$().graph().concept(RESTService.Resource.Parameter.class).createNode(this.name, Notification.this.core$()).as(RESTService.Resource.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public RESTService.Notification.Parameter parameter(RESTService.Notification.Parameter.In in) {
                RESTService.Notification.Parameter newElement = (RESTService.Notification.Parameter)Notification.this.core$().graph().concept(RESTService.Notification.Parameter.class).createNode(this.name, Notification.this.core$()).as(RESTService.Notification.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }
        }
    }

    public static class Request
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Exception> exceptionRefs = new ArrayList<Exception>();
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();
        protected Response response;

        public Request(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public List<Exception> exceptionRefs() {
            return this.exceptionRefs;
        }

        public Exception exceptionRefs(int index) {
            return this.exceptionRefs.get(index);
        }

        public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
            return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
        }

        public Request path(String value) {
            this.path = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Response response() {
            return this.response;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            if (this.response != null) {
                components.add(this.response.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            map.put("exceptionRefs", this.exceptionRefs);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = (Response)node.as(Response.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            } else if (name.equalsIgnoreCase("exceptionRefs")) {
                this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Request.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Request.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Request.this.core$().graph().concept(Parameter.class).createNode(this.name, Request.this.core$()).as(Parameter.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Request.this.core$().graph().concept(Exception.class).createNode(this.name, Request.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }

            public Response response() {
                Response newElement = (Response)Request.this.core$().graph().concept(Response.class).createNode(this.name, Request.this.core$()).as(Response.class);
                return newElement;
            }

            public RESTService.Resource.Parameter parameter(RESTService.Resource.Parameter.In in) {
                RESTService.Resource.Parameter newElement = (RESTService.Resource.Parameter)Request.this.core$().graph().concept(RESTService.Resource.Parameter.class).createNode(this.name, Request.this.core$()).as(RESTService.Resource.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public RESTService.Notification.Parameter parameter(RESTService.Notification.Parameter.In in) {
                RESTService.Notification.Parameter newElement = (RESTService.Notification.Parameter)Request.this.core$().graph().concept(RESTService.Notification.Parameter.class).createNode(this.name, Request.this.core$()).as(RESTService.Notification.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public Redirect redirect() {
                Redirect newElement = (Redirect)Request.this.core$().graph().concept(Redirect.class).createNode(this.name, Request.this.core$()).as(Redirect.class);
                return newElement;
            }
        }
    }

    public class Clear {
        public void request(Predicate<Request> filter) {
            new ArrayList<Request>(JMSService.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(JMSService.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void credentialSecured(Predicate<CredentialSecured> filter) {
            new ArrayList<CredentialSecured>(JMSService.this.credentialSecuredList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void certificateSecured(Predicate<CertificateSecured> filter) {
            new ArrayList<CertificateSecured>(JMSService.this.certificateSecuredList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(JMSService.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(JMSService.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Request request(String path) {
            Request newElement = (Request)JMSService.this.core$().graph().concept(Request.class).createNode(this.name, JMSService.this.core$()).as(Request.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public Notification notification(String path) {
            Notification newElement = (Notification)JMSService.this.core$().graph().concept(Notification.class).createNode(this.name, JMSService.this.core$()).as(Notification.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public CredentialSecured credentialSecured(String username, String password) {
            CredentialSecured newElement = (CredentialSecured)JMSService.this.core$().graph().concept(CredentialSecured.class).createNode(this.name, JMSService.this.core$()).as(CredentialSecured.class);
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
            return newElement;
        }

        public CertificateSecured certificateSecured(String certificate) {
            CertificateSecured newElement = (CertificateSecured)JMSService.this.core$().graph().concept(CertificateSecured.class).createNode(this.name, JMSService.this.core$()).as(CertificateSecured.class);
            newElement.core$().set((Layer)newElement, "certificate", Collections.singletonList(certificate));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)JMSService.this.core$().graph().concept(Schema.class).createNode(this.name, JMSService.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)JMSService.this.core$().graph().concept(Exception.class).createNode(this.name, JMSService.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }

    public static enum SubscriptionModel {
        Queue,
        Topic;

    }
}

