/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class RestResourceTemplate
extends Template {
    protected RestResourceTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new RestResourceTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "notification")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".rest.notifications;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.Resource;\nimport io.intino.alexandria.rest.pushservice.Client;\nimport io.intino.alexandria.rest.pushservice.Session;\nimport io.intino.alexandria.rest.pushservice.MessageCarrier;\nimport io.intino.alexandria.rest.spark.SparkManager;\nimport io.intino.alexandria.rest.spark.SparkNotifier;\nimport io.intino.alexandria.rest.spark.SparkPushService;\n\n")).add((Token.Body)this.mark("schemaImport", new String[0])).add((Token.Body)this.literal("\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Notification implements Resource {\n\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box;\n\tprivate SparkManager<SparkPushService> manager;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"field"}))).add((Token.Body)this.literal("\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Notification(")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box, SparkManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"assign"})).add((Token.Body)this.literal("\n\t}\n\n\tpublic void execute()")).add((Token.Body)this.expression().add((Token.Body)this.literal(" throws ")).add((Token.Body)this.mark("throws", new String[0]).multiple(", "))).add((Token.Body)this.literal(" {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("authenticationValidator", new String[]{"validate"}))).add((Token.Body)this.literal("\n\t\tSession session = manager.currentSession();\n\t\tString clientId = java.util.UUID.randomUUID().toString();\n\t\t")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action action = fill(new ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action());\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\taction.onOpen(client, notifier(session, client));\n\t\t\treturn true;\n\t\t});\n\t\tmanager.pushService().onClose(clientId).execute((java.util.function.Consumer<Client>) action::onClose);\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("returnType", new String[]{"methodCall"}))).add((Token.Body)this.literal("manager.baseUrl().replace(\"http\", \"ws\") + \"/push?id=\" + clientId")).add((Token.Body)this.expression().add((Token.Body)this.mark("returnType", new String[]{"ending"}))).add((Token.Body)this.literal(";\n\t}\n\n\tprivate ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action fill(")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action action) {\n\t\taction.box = this.box;\n\t\taction.context = context();")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n"))).add((Token.Body)this.literal("\n\t\treturn action;\n\t}\n\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("returnType", new String[]{"method"}))).add((Token.Body)this.literal("\n\n\tprivate SparkNotifier notifier(Session session, Client client) {\n\t\treturn new SparkNotifier(new MessageCarrier(manager.pushService(), session, client));\n\t}\n\n\tprivate io.intino.alexandria.core.Context context() {\n\t\tio.intino.alexandria.core.Context context = new io.intino.alexandria.core.Context();\n\t\tcontext.put(\"domain\", manager.domain());\n\t\tcontext.put(\"baseUrl\", manager.baseUrl());\n\t\tcontext.put(\"requestUrl\", manager.baseUrl() + manager.request().pathInfo());\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("authenticationValidator", new String[]{"put"}))).add((Token.Body)this.literal("\n\t\treturn context;\n\t}\n}\n\n")), this.rule().add(new Condition[]{this.condition("type", "resource")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".rest.resources;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport io.intino.alexandria.exceptions.*;\nimport ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".*;\nimport io.intino.alexandria.core.Box;\nimport io.intino.alexandria.rest.Resource;\nimport io.intino.alexandria.rest.spark.SparkManager;\nimport io.intino.alexandria.rest.spark.SparkPushService;\n\n")).add((Token.Body)this.mark("schemaImport", new String[0])).add((Token.Body)this.literal("\n\npublic class ")).add((Token.Body)this.mark("operation", new String[]{"firstUpperCase"})).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Resource implements Resource {\n\n\tprivate ")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box;\n\tprivate SparkManager<SparkPushService> manager;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"field"}))).add((Token.Body)this.literal("\n\n\tpublic ")).add((Token.Body)this.mark("operation", new String[]{"firstUpperCase"})).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Resource(")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box, SparkManager manager) {\n\t\tthis.box = box;\n\t\tthis.manager = manager;\n\t\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"assign"})).add((Token.Body)this.literal("\n\t}\n\n\tpublic void execute() throws ")).add((Token.Body)this.mark("throws", new String[0]).multiple(", ")).add((Token.Body)this.literal(" {")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"validate"}))).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("returnType", new String[]{"methodCall"}))).add((Token.Body)this.literal("fill(new ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("operation", new String[]{"firstUpperCase"})).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action()).execute()")).add((Token.Body)this.expression().add((Token.Body)this.mark("returnType", new String[]{"ending"}))).add((Token.Body)this.literal(";\n\t}\n\n\tprivate ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("operation", new String[]{"firstUpperCase"})).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action fill(")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("operation", new String[]{"firstUpperCase"})).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action action) {\n\t\taction.box = this.box;\n\t\taction.context = context();")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("parameter", new String[]{"assign"}).multiple("\n"))).add((Token.Body)this.literal("\n\t\treturn action;\n\t}\n\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("returnType", new String[]{"method"}))).add((Token.Body)this.literal("\n\n\tprivate io.intino.alexandria.core.Context context() {\n\t\tio.intino.alexandria.core.Context context = new io.intino.alexandria.core.Context();\n\t\tcontext.put(\"domain\", manager.domain());\n\t\tcontext.put(\"baseUrl\", manager.baseUrl());\n\t\tcontext.put(\"requestUrl\", manager.baseUrl() + manager.request().pathInfo());\n\t\t")).add((Token.Body)this.mark("authenticationValidator", new String[]{"put"})).add((Token.Body)this.literal("\n\t\treturn context;\n\t}\n}")), this.rule().add(new Condition[]{this.condition("attribute", "void"), this.condition("trigger", "methodCall")}), this.rule().add(new Condition[]{this.condition("type", "redirect"), this.condition("trigger", "methodCall")}).add((Token.Body)this.literal("redirect(")), this.rule().add(new Condition[]{this.condition("type", "response"), this.condition("trigger", "methodCall")}).add((Token.Body)this.literal("write(")), this.rule().add(new Condition[]{this.condition("attribute", "void"), this.condition("trigger", "ending")}), this.rule().add(new Condition[]{this.condition("trigger", "ending")}).add((Token.Body)this.literal(")")), this.rule().add(new Condition[]{this.condition("attribute", "void"), this.condition("trigger", "write")}), this.rule().add(new Condition[]{this.condition("type", "redirect"), this.condition("trigger", "method")}).add((Token.Body)this.literal("private void redirect(String url) {\n\tmanager.redirect(url);\n}")), this.rule().add(new Condition[]{this.condition("type", "response"), this.condition("trigger", "method")}).add((Token.Body)this.literal("private void write(")).add((Token.Body)this.mark("value", new String[]{"firstUpperCase", "ReturnTypeFormatter"})).add((Token.Body)this.literal(" object) {\n\tmanager.write(object")).add((Token.Body)this.expression().add((Token.Body)this.literal(", \"")).add((Token.Body)this.mark("format", new String[0])).add((Token.Body)this.literal("\""))).add((Token.Body)this.literal(");\n}")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "type")}).add((Token.Body)this.mark("parameterType", new String[0])), this.rule().add(new Condition[]{this.condition("type", "parameter & defaultvalue"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = manager.from")).add((Token.Body)this.mark("in", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("OrDefault(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", ")).add((Token.Body)this.mark("parameterType", new String[0])).add((Token.Body)this.literal(", \"")).add((Token.Body)this.mark("defaultvalue", new String[0])).add((Token.Body)this.literal("\");")), this.rule().add(new Condition[]{this.condition("type", "parameter"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = manager.from")).add((Token.Body)this.mark("in", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", ")).add((Token.Body)this.mark("parameterType", new String[0])).add((Token.Body)this.literal(");")), this.rule().add(new Condition[]{this.condition("type", "list"), this.condition("trigger", "parameterType")}).add((Token.Body)this.literal("com.google.gson.reflect.TypeToken.getParameterized(java.util.ArrayList.class, ")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(".class).getType()")), this.rule().add(new Condition[]{this.condition("type", "authenticationValidator"), this.condition("trigger", "field")}).add((Token.Body)this.literal("io.intino.alexandria.rest.security.")).add((Token.Body)this.mark("type", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("AuthenticationValidator validator;")), this.rule().add(new Condition[]{this.condition("type", "authenticationValidator"), this.condition("trigger", "assign")}).add((Token.Body)this.literal("this.validator = box.authenticationValidator();")), this.rule().add(new Condition[]{this.condition("type", "authenticationValidator"), this.condition("trigger", "validate")}).add((Token.Body)this.literal("String auth = manager.fromHeader(\"Authorization\", String.class);\nif (auth == null || !validator.validate(auth.replace(\"Basic \", \"\"))) throw new Unauthorized(\"Credential not found\");")), this.rule().add(new Condition[]{this.condition("type", "authenticationValidator"), this.condition("trigger", "put")}).add((Token.Body)this.literal("context.put(\"auth\", manager.fromHeader(\"Authorization\", String.class).replace(\"Basic \", \"\"));")), this.rule().add(new Condition[]{this.condition("trigger", "parameterType")}).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal(".class")), this.rule().add(new Condition[]{this.condition("type", "schemaImport")}).add((Token.Body)this.literal("import ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".schemas.*;"))});
        return this;
    }
}

